/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.RedundantJoinFKOptimizer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public class RedundantJoinFKOptimizerImpl
implements RedundantJoinFKOptimizer {
    private final RedundantJoinFKTransformer transformer;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private RedundantJoinFKOptimizerImpl(CoreSingletons coreSingletons) {
        this.transformer = new RedundantJoinFKTransformer(coreSingletons);
        this.iqFactory = coreSingletons.getIQFactory();
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree newTree = this.transformer.transform(query.normalizeForOptimization().getTree());
        return newTree.equals(query.getTree()) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree).normalizeForOptimization();
    }

    protected static class RedundantJoinFKTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        protected final TermFactory termFactory;

        protected RedundantJoinFKTransformer(CoreSingletons coreSingletons) {
            super(coreSingletons);
            this.termFactory = coreSingletons.getTermFactory();
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> initialChildren) {
            ImmutableList liftedChildren = (ImmutableList)initialChildren.stream().map(t -> t.acceptTransformer((IQTreeVisitingTransformer)this)).collect(ImmutableCollectors.toList());
            ImmutableMap childPartitions = (ImmutableMap)liftedChildren.stream().collect(ImmutableCollectors.partitioningBy(n -> n instanceof ExtensionalDataNode));
            Optional<ImmutableList> optionalExtensionalChildren = Optional.ofNullable((ImmutableList)childPartitions.get((Object)true));
            if (!optionalExtensionalChildren.isPresent()) {
                return liftedChildren.equals(initialChildren) ? tree : this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, liftedChildren);
            }
            return this.optimizeExtensionalChildren((ImmutableList<ExtensionalDataNode>)optionalExtensionalChildren.get()).map(extensionalChildren -> this.buildNewTree(rootNode, (IQTree)extensionalChildren, (ImmutableList<IQTree>)Optional.ofNullable((ImmutableList)childPartitions.get((Object)false)).orElseGet(ImmutableList::of))).orElseGet(() -> liftedChildren.equals((Object)initialChildren) ? tree : this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, liftedChildren));
        }

        protected Optional<IQTree> optimizeExtensionalChildren(ImmutableList<ExtensionalDataNode> extensionalChildren) {
            ImmutableMap dataNodeMap = ((ImmutableMultimap)extensionalChildren.stream().collect(ImmutableCollectors.toMultimap(ExtensionalDataNode::getRelationDefinition, c -> c))).asMap();
            ImmutableSet<ExtensionalDataNode> redundantNodes = this.extractRedundantNodes((ImmutableMap<RelationDefinition, Collection<ExtensionalDataNode>>)dataNodeMap);
            if (redundantNodes.isEmpty()) {
                return Optional.empty();
            }
            Optional newConditions = this.termFactory.getDBIsNotNull(redundantNodes.stream().flatMap(n -> n.getVariables().stream()).distinct());
            ImmutableList remainingChildren = (ImmutableList)extensionalChildren.stream().filter(n -> !redundantNodes.contains(n)).collect(ImmutableCollectors.toList());
            switch (remainingChildren.size()) {
                case 0: {
                    throw new IllegalStateException("At least one child must remain");
                }
                case 1: {
                    return Optional.of(newConditions.map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(c), (IQTree)remainingChildren.get(0))).orElseGet(() -> (IQTree)remainingChildren.get(0)));
                }
            }
            return Optional.of(this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(newConditions), remainingChildren));
        }

        private ImmutableSet<ExtensionalDataNode> extractRedundantNodes(ImmutableMap<RelationDefinition, Collection<ExtensionalDataNode>> dataNodeMap) {
            HashSet redundantNodes = new HashSet();
            for (Map.Entry entry : dataNodeMap.entrySet()) {
                redundantNodes.addAll((Collection)((RelationDefinition)entry.getKey()).getForeignKeys().stream().flatMap(fk -> Optional.ofNullable((Collection)dataNodeMap.get((Object)fk.getReferencedRelation())).map(Collection::stream).orElseGet(Stream::empty).filter(targetNode -> this.isJustHavingFKArguments((ForeignKeyConstraint)fk, (ExtensionalDataNode)targetNode)).filter(targetNode -> ((Collection)entry.getValue()).stream().anyMatch(s -> !redundantNodes.contains(s) && this.isSafeAndTargetMatching((ForeignKeyConstraint)fk, (ExtensionalDataNode)s, (ExtensionalDataNode)targetNode)))).collect(ImmutableCollectors.toSet()));
            }
            return ImmutableSet.copyOf(redundantNodes);
        }

        private boolean isJustHavingFKArguments(ForeignKeyConstraint foreignKeyConstraint, ExtensionalDataNode targetNode) {
            ImmutableMap targetArgumentMap = targetNode.getArgumentMap();
            return targetArgumentMap.keySet().equals(foreignKeyConstraint.getComponents().stream().map(c -> c.getReferencedAttribute().getIndex() - 1).collect(ImmutableCollectors.toSet()));
        }

        private boolean isSafeAndTargetMatching(ForeignKeyConstraint foreignKeyConstraint, ExtensionalDataNode sourceNode, ExtensionalDataNode targetNode) {
            if (sourceNode.equals(targetNode)) {
                return false;
            }
            ImmutableMap sourceArgumentMap = sourceNode.getArgumentMap();
            if (!foreignKeyConstraint.getComponents().stream().map(c -> c.getAttribute().getIndex() - 1).allMatch(arg_0 -> ((ImmutableMap)sourceArgumentMap).containsKey(arg_0))) {
                return false;
            }
            ImmutableMap targetArgumentMap = targetNode.getArgumentMap();
            return foreignKeyConstraint.getComponents().stream().allMatch(c -> ((VariableOrGroundTerm)sourceArgumentMap.get((Object)(c.getAttribute().getIndex() - 1))).equals(targetArgumentMap.get((Object)(c.getReferencedAttribute().getIndex() - 1))));
        }

        private IQTree buildNewTree(InnerJoinNode rootNode, IQTree optimizedChildTree, ImmutableList<IQTree> otherChildren) {
            ImmutableList newChildren = (ImmutableList)Stream.concat(Stream.of(optimizedChildTree), otherChildren.stream()).collect(ImmutableCollectors.toList());
            switch (newChildren.size()) {
                case 0: {
                    throw new IllegalStateException("The optimization should not eliminate all the children");
                }
                case 1: {
                    return rootNode.getOptionalFilterCondition().isPresent() ? this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode((ImmutableExpression)rootNode.getOptionalFilterCondition().get()), (IQTree)newChildren.get(0)) : (IQTree)newChildren.get(0);
                }
            }
            return this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, newChildren);
        }
    }
}

