/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.optimizer.AggregationSimplifier;
import it.unibz.inf.ontop.iq.optimizer.AggregationSplitter;
import it.unibz.inf.ontop.iq.optimizer.GeneralStructuralAndSemanticIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.JoinLikeOptimizer;
import it.unibz.inf.ontop.iq.optimizer.OrderBySimplifier;
import it.unibz.inf.ontop.iq.optimizer.UnionAndBindingLiftOptimizer;
import it.unibz.inf.ontop.iq.view.OntopViewUnfolder;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GeneralStructuralAndSemanticIQOptimizerImpl
implements GeneralStructuralAndSemanticIQOptimizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralStructuralAndSemanticIQOptimizerImpl.class);
    private final UnionAndBindingLiftOptimizer bindingLiftOptimizer;
    private final JoinLikeOptimizer joinLikeOptimizer;
    private final OrderBySimplifier orderBySimplifier;
    private final AggregationSimplifier aggregationSimplifier;
    private final OntopViewUnfolder viewUnfolder;
    private final AggregationSplitter aggregationSplitter;

    @Inject
    private GeneralStructuralAndSemanticIQOptimizerImpl(UnionAndBindingLiftOptimizer bindingLiftOptimizer, JoinLikeOptimizer joinLikeOptimizer, OrderBySimplifier orderBySimplifier, AggregationSimplifier aggregationSimplifier, OntopViewUnfolder viewUnfolder, AggregationSplitter aggregationSplitter) {
        this.bindingLiftOptimizer = bindingLiftOptimizer;
        this.joinLikeOptimizer = joinLikeOptimizer;
        this.orderBySimplifier = orderBySimplifier;
        this.aggregationSimplifier = aggregationSimplifier;
        this.viewUnfolder = viewUnfolder;
        this.aggregationSplitter = aggregationSplitter;
    }

    @Override
    public IQ optimize(IQ query) {
        IQ queryBeforeUnfolding;
        IQ liftedQuery = this.bindingLiftOptimizer.optimize(query);
        LOGGER.debug("New lifted query:\n{}\n", (Object)liftedQuery);
        IQ queryAfterJoinLikeAndViewUnfolding = liftedQuery;
        do {
            long beginningJoinLike = System.currentTimeMillis();
            queryAfterJoinLikeAndViewUnfolding = this.joinLikeOptimizer.optimize(queryAfterJoinLikeAndViewUnfolding);
            LOGGER.debug("New query after fixed point join optimization ({} ms):\n{}\n", (Object)(System.currentTimeMillis() - beginningJoinLike), (Object)queryAfterJoinLikeAndViewUnfolding);
        } while (!(queryBeforeUnfolding = queryAfterJoinLikeAndViewUnfolding).equals(queryAfterJoinLikeAndViewUnfolding = this.viewUnfolder.optimize(queryBeforeUnfolding)));
        IQ queryAfterAggregationSimplification = this.aggregationSimplifier.optimize(queryAfterJoinLikeAndViewUnfolding);
        LOGGER.debug("New query after simplifying the aggregation node:\n{}\n", (Object)queryAfterAggregationSimplification);
        IQ queryAfterAggregationSplitting = this.aggregationSplitter.optimize(queryAfterAggregationSimplification);
        LOGGER.debug("New query after trying to split the aggregation node:\n{}\n", (Object)queryAfterAggregationSplitting);
        IQ optimizedQuery = this.orderBySimplifier.optimize(queryAfterAggregationSplitting);
        LOGGER.debug("New query after simplifying the order by node:\n{}\n", (Object)optimizedQuery);
        return optimizedQuery;
    }
}

