/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultiset;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Multiset;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.optimizer.InnerJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.AbstractSelfJoinSimplifier;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ArgumentTransferInnerJoinFDIQOptimizer
implements InnerJoinIQOptimizer {
    private final ArgumentTransferJoinTransformer transformer;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected ArgumentTransferInnerJoinFDIQOptimizer(CoreSingletons coreSingletons) {
        SelfJoinFDSimplifier simplifier = new SelfJoinFDSimplifier(coreSingletons);
        this.transformer = new ArgumentTransferJoinTransformer(simplifier, coreSingletons);
        this.iqFactory = coreSingletons.getIQFactory();
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree initialTree = query.getTree();
        IQTree newTree = this.transformer.transform(initialTree);
        return newTree == initialTree ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree).normalizeForOptimization();
    }

    protected static class SelfJoinFDSimplifier
    extends AbstractSelfJoinSimplifier<FunctionalDependency> {
        protected SelfJoinFDSimplifier(CoreSingletons coreSingletons) {
            super(coreSingletons);
        }

        @Override
        protected boolean canEliminateNodes() {
            return false;
        }

        @Override
        protected boolean hasConstraint(ExtensionalDataNode node) {
            return !node.getRelationDefinition().getOtherFunctionalDependencies().isEmpty();
        }

        @Override
        protected Stream<FunctionalDependency> extractConstraints(RelationDefinition relationDefinition) {
            return relationDefinition.getOtherFunctionalDependencies().stream();
        }

        @Override
        protected Optional<AbstractSelfJoinSimplifier.DeterminantGroupEvaluation> evaluateDeterminantGroup(ImmutableList<VariableOrGroundTerm> determinants, Collection<ExtensionalDataNode> dataNodes, FunctionalDependency constraint) {
            if (dataNodes.size() < 2) {
                throw new IllegalArgumentException("At least two nodes");
            }
            AbstractSelfJoinSimplifier.NormalizationBeforeUnification normalization = this.normalizeDataNodes(dataNodes, constraint);
            ExtensionalDataNode targetDataNode = this.selectTargetDataNode(normalization.dataNodes, constraint);
            ImmutableSet dependentIndexes = (ImmutableSet)constraint.getDependents().stream().map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toSet());
            ImmutableSet<ImmutableExpression> expressions = this.extractExpressions(dataNodes, normalization.equalities, (ImmutableSet<Integer>)dependentIndexes);
            return this.unifyDataNodes(normalization.dataNodes.stream(), n -> SelfJoinFDSimplifier.extractDependentArgumentMap(n, (ImmutableSet<Integer>)dependentIndexes)).map(u -> this.convertIntoDeterminantGroupEvaluation((ImmutableUnificationTools.ArgumentMapUnification)u, targetDataNode, (ImmutableList<ExtensionalDataNode>)ImmutableList.copyOf(normalization.dataNodes), expressions, (ImmutableSet<Integer>)dependentIndexes));
        }

        protected ExtensionalDataNode selectTargetDataNode(Collection<ExtensionalDataNode> dataNodes, FunctionalDependency constraint) {
            ImmutableSet dependentAttributes = constraint.getDependents();
            ImmutableSet determinantAttributes = constraint.getDeterminants();
            RelationDefinition relationDefinition = dataNodes.iterator().next().getRelationDefinition();
            ImmutableList externalArgumentIndexes = (ImmutableList)relationDefinition.getAttributes().stream().filter(a -> !dependentAttributes.contains(a)).filter(a -> !determinantAttributes.contains(a)).map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toList());
            ImmutableMap nodeExternalArgumentMap = (ImmutableMap)dataNodes.stream().distinct().collect(ImmutableCollectors.toMap(n -> n, n -> (ImmutableMap)n.getArgumentMap().entrySet().stream().filter(e -> externalArgumentIndexes.contains(e.getKey())).collect(ImmutableCollectors.toMap())));
            return dataNodes.stream().max(Comparator.comparingInt(n -> ((ImmutableMap)nodeExternalArgumentMap.get(n)).values().size())).orElseThrow(() -> new MinorOntopInternalBugException("Non empty collection expected"));
        }

        private static ImmutableMap<Integer, ? extends VariableOrGroundTerm> extractDependentArgumentMap(ExtensionalDataNode node, ImmutableSet<Integer> dependentIndexes) {
            return (ImmutableMap)node.getArgumentMap().entrySet().stream().filter(e -> dependentIndexes.contains(e.getKey())).collect(ImmutableCollectors.toMap());
        }

        private AbstractSelfJoinSimplifier.DeterminantGroupEvaluation convertIntoDeterminantGroupEvaluation(ImmutableUnificationTools.ArgumentMapUnification argumentMapUnification, ExtensionalDataNode targetDataNode, ImmutableList<ExtensionalDataNode> dataNodes, ImmutableSet<ImmutableExpression> expressions, ImmutableSet<Integer> dependentIndexes) {
            ImmutableMap targetArgumentMap = targetDataNode.getArgumentMap();
            ImmutableMap newTargetArgumentMap = (ImmutableMap)Sets.union((Set)argumentMapUnification.argumentMap.keySet(), (Set)targetArgumentMap.keySet()).stream().sorted().collect(ImmutableCollectors.toMap(i -> i, i -> Optional.ofNullable((VariableOrGroundTerm)argumentMapUnification.argumentMap.get(i)).orElseGet(() -> (VariableOrGroundTerm)targetArgumentMap.get(i))));
            int targetIndex = dataNodes.indexOf((Object)targetDataNode);
            ImmutableList newNodes = (ImmutableList)IntStream.range(0, dataNodes.size()).mapToObj(i -> i == targetIndex ? this.iqFactory.createExtensionalDataNode(targetDataNode.getRelationDefinition(), newTargetArgumentMap) : this.removeDependentArguments((ExtensionalDataNode)dataNodes.get(i), dependentIndexes)).collect(ImmutableCollectors.toList());
            return new AbstractSelfJoinSimplifier.DeterminantGroupEvaluation(expressions, (ImmutableList<ExtensionalDataNode>)newNodes, (ImmutableSubstitution<VariableOrGroundTerm>)argumentMapUnification.substitution);
        }

        private ExtensionalDataNode removeDependentArguments(ExtensionalDataNode extensionalDataNode, ImmutableSet<Integer> dependentIndexes) {
            ImmutableMap newArgumentMap = (ImmutableMap)extensionalDataNode.getArgumentMap().entrySet().stream().filter(e -> !dependentIndexes.contains(e.getKey())).collect(ImmutableCollectors.toMap());
            return this.iqFactory.createExtensionalDataNode(extensionalDataNode.getRelationDefinition(), newArgumentMap);
        }

        private ImmutableSet<ImmutableExpression> extractExpressions(Collection<ExtensionalDataNode> dataNodes, ImmutableSet<ImmutableExpression> equalities, ImmutableSet<Integer> dependentIndexes) {
            ImmutableMultiset dependentVariableOccurrences = (ImmutableMultiset)dataNodes.stream().flatMap(n -> n.getArgumentMap().entrySet().stream()).filter(e -> !dependentIndexes.contains(e.getKey())).map(Map.Entry::getValue).filter(d -> d instanceof Variable).map(d -> (Variable)d).collect(ImmutableCollectors.toMultiset());
            return (ImmutableSet)Stream.concat(dependentVariableOccurrences.entrySet().stream().filter(e -> e.getCount() > 1).map(Multiset.Entry::getElement).map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0)), equalities.stream()).collect(ImmutableCollectors.toSet());
        }
    }

    protected static class ArgumentTransferJoinTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final SelfJoinFDSimplifier simplifier;

        protected ArgumentTransferJoinTransformer(SelfJoinFDSimplifier simplifier, CoreSingletons coreSingletons) {
            super(coreSingletons);
            this.simplifier = simplifier;
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            return this.simplifier.transformInnerJoin(rootNode, children, (ImmutableSet<Variable>)tree.getVariables()).orElse(tree);
        }
    }
}

