/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultiset;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Lists;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.optimizer.AggregationSplitter;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class AggregationSplitterImpl
implements AggregationSplitter {
    private final CoreSingletons coreSingletons;

    @Inject
    protected AggregationSplitterImpl(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree tree;
        IQ normalizedQuery = query.normalizeForOptimization();
        AggregationUnionLifterTransformer transformer = new AggregationUnionLifterTransformer(this.coreSingletons, query.getVariableGenerator());
        IQTree newTree = transformer.transform(tree = normalizedQuery.getTree());
        return newTree == tree ? normalizedQuery : this.coreSingletons.getIQFactory().createIQ(normalizedQuery.getProjectionAtom(), newTree).normalizeForOptimization();
    }

    protected static class ChildGroup {
        private final Set<IQTree> trees;
        private final Set<NonVariableTerm> definitions;

        public ChildGroup(IQTree tree, Set<NonVariableTerm> treeDefinitions) {
            this.trees = Sets.newHashSet((Object[])new IQTree[]{tree});
            this.definitions = Sets.newHashSet(treeDefinitions);
        }

        public boolean addIfCompatible(IQTree tree, Set<NonVariableTerm> treeDefinitions, VariableNullability variableNullability, TermFactory termFactory) {
            for (NonVariableTerm definition : treeDefinitions) {
                if (!this.definitions.contains(definition) && !this.definitions.stream().anyMatch(d -> this.areCompatibleGroupingConditions((NonVariableTerm)d, definition, variableNullability, termFactory))) continue;
                this.trees.add(tree);
                this.definitions.addAll(treeDefinitions);
                return true;
            }
            return false;
        }

        private boolean areCompatibleGroupingConditions(NonVariableTerm t1, NonVariableTerm t2, VariableNullability variableNullability, TermFactory termFactory) {
            if (t1.isNull() && !t2.isNullable(variableNullability.getNullableVariables()) || t2.isNull() && !t1.isNullable(variableNullability.getNullableVariables())) {
                return false;
            }
            return !termFactory.getStrictEquality((ImmutableTerm)t1, (ImmutableTerm)t2, new ImmutableTerm[0]).evaluate2VL(variableNullability).isEffectiveFalse();
        }

        public boolean mergeIfCompatible(ChildGroup group) {
            if (group.definitions.stream().anyMatch(this.definitions::contains)) {
                this.definitions.addAll(group.definitions);
                this.trees.addAll(group.trees);
                return true;
            }
            return false;
        }

        public ImmutableSet<IQTree> getTrees() {
            return ImmutableSet.copyOf(this.trees);
        }
    }

    protected static class AggregationUnionLifterTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final VariableGenerator variableGenerator;
        private final SubstitutionFactory substitutionFactory;
        private final TermFactory termFactory;

        protected AggregationUnionLifterTransformer(CoreSingletons coreSingletons, VariableGenerator variableGenerator) {
            super(coreSingletons);
            this.variableGenerator = variableGenerator;
            this.substitutionFactory = coreSingletons.getSubstitutionFactory();
            this.termFactory = coreSingletons.getTermFactory();
        }

        public IQTree transformAggregation(IQTree tree, AggregationNode rootNode, IQTree child) {
            IQTree liftedChild = child.acceptTransformer((IQTreeVisitingTransformer)this);
            return this.tryToLift(rootNode, liftedChild).orElseGet(() -> liftedChild == child ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, liftedChild));
        }

        private Optional<IQTree> tryToLift(AggregationNode rootNode, IQTree child) {
            ImmutableSet groupingVariables = rootNode.getGroupingVariables();
            Optional<ConstructionNode> topChildConstructionNode = Optional.of(child.getRootNode()).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n);
            IQTree nonTopConstructionDescendant = topChildConstructionNode.map(cst -> ((UnaryIQTree)child).getChild()).orElse(child);
            Optional<DistinctNode> distinctDescendantNode = Optional.of(nonTopConstructionDescendant).map(IQTree::getRootNode).filter(n -> n instanceof DistinctNode).map(n -> (DistinctNode)n);
            IQTree nonTopConstructionNonDistinctDescendant = distinctDescendantNode.map(cst -> ((UnaryIQTree)nonTopConstructionDescendant).getChild()).orElse(nonTopConstructionDescendant);
            Optional<ConstructionNode> subConstructionDescendantNode = Optional.of(nonTopConstructionNonDistinctDescendant).map(IQTree::getRootNode).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n);
            IQTree nonConstructionNonDistinctDescendant = subConstructionDescendantNode.map(cst -> ((UnaryIQTree)nonTopConstructionNonDistinctDescendant).getChild()).orElse(nonTopConstructionNonDistinctDescendant);
            if (!(nonConstructionNonDistinctDescendant.getRootNode() instanceof UnionNode)) {
                return Optional.empty();
            }
            ImmutableSet groupingVariablesWithDifferentDefinitions = (ImmutableSet)groupingVariables.stream().filter(arg_0 -> ((IQTree)child).isConstructed(arg_0)).filter(v -> !topChildConstructionNode.filter(n -> n.getSubstitution().isDefining(v)).isPresent()).filter(v -> !subConstructionDescendantNode.filter(n -> n.getSubstitution().isDefining(v)).isPresent()).collect(ImmutableCollectors.toSet());
            if (groupingVariablesWithDifferentDefinitions.isEmpty()) {
                return Optional.empty();
            }
            ImmutableMultiset unionChildren = ImmutableMultiset.copyOf((Iterable)nonConstructionNonDistinctDescendant.getChildren());
            VariableNullability variableNullability = nonConstructionNonDistinctDescendant.getVariableNullability();
            ImmutableList groups = groupingVariablesWithDifferentDefinitions.stream().reduce(ImmutableList.of((Object)ImmutableSet.copyOf((Collection)unionChildren)), (gs, v) -> (ImmutableList)gs.stream().flatMap(g -> this.tryToSplit((ImmutableSet<IQTree>)g, (Variable)v, variableNullability)).collect(ImmutableCollectors.toList()), (gs1, gs2) -> {
                throw new RuntimeException("Not to be run in // ");
            });
            if (groups.size() <= 1) {
                return Optional.empty();
            }
            return Optional.of(this.liftUnion((ImmutableList<ImmutableSet<IQTree>>)groups, topChildConstructionNode, distinctDescendantNode, subConstructionDescendantNode, rootNode, (ImmutableMultiset<IQTree>)unionChildren));
        }

        private Stream<ImmutableSet<IQTree>> tryToSplit(ImmutableSet<IQTree> initialGroup, Variable groupingVariable, VariableNullability variableNullability) {
            ArrayList groups = Lists.newArrayList();
            for (IQTree tree : initialGroup) {
                Optional<ImmutableSet<NonVariableTerm>> optionalDefinitions = this.getDefinitions(tree, groupingVariable);
                if (!optionalDefinitions.isPresent()) {
                    return Stream.of(initialGroup);
                }
                ImmutableSet<NonVariableTerm> treeDefinitions = optionalDefinitions.get();
                boolean foundAGroup = false;
                for (ChildGroup group : groups) {
                    if (!group.addIfCompatible(tree, (Set<NonVariableTerm>)treeDefinitions, variableNullability, this.termFactory)) continue;
                    foundAGroup = true;
                }
                if (foundAGroup) continue;
                groups.add(new ChildGroup(tree, (Set<NonVariableTerm>)treeDefinitions));
            }
            if (groups.size() < 2) {
                return Stream.of(initialGroup);
            }
            return this.mergeGroups(groups);
        }

        private Optional<ImmutableSet<NonVariableTerm>> getDefinitions(IQTree tree, Variable variable) {
            ImmutableSet possibleValues = (ImmutableSet)tree.getPossibleVariableDefinitions().stream().map(s -> s.applyToVariable(variable)).collect(ImmutableCollectors.toSet());
            if (possibleValues.isEmpty() || possibleValues.stream().anyMatch(t -> t instanceof Variable)) {
                return Optional.empty();
            }
            return Optional.of(possibleValues);
        }

        private Stream<ImmutableSet<IQTree>> mergeGroups(List<ChildGroup> nonMergedGroups) {
            ArrayList mergedGroups = Lists.newArrayList();
            for (ChildGroup nonMergedGroup : nonMergedGroups) {
                boolean mergedInAGroup = false;
                for (ChildGroup group : mergedGroups) {
                    if (!group.mergeIfCompatible(nonMergedGroup)) continue;
                    mergedInAGroup = true;
                    break;
                }
                if (mergedInAGroup) continue;
                mergedGroups.add(nonMergedGroup);
            }
            return mergedGroups.stream().map(ChildGroup::getTrees);
        }

        protected IQTree liftUnion(ImmutableList<ImmutableSet<IQTree>> groups, Optional<ConstructionNode> childConstructionNode, Optional<DistinctNode> distinctDescendantNode, Optional<ConstructionNode> subConstructionDescendantNode, AggregationNode initialAggregationNode, ImmutableMultiset<IQTree> unionChildren) {
            Sets.SetView nonGroupingVariables = Sets.difference((Set)initialAggregationNode.getChildVariables(), (Set)initialAggregationNode.getGroupingVariables());
            ImmutableList multiGroups = (ImmutableList)groups.stream().map(g -> (ImmutableList)unionChildren.entrySet().stream().filter(e -> g.contains(e.getElement())).flatMap(e -> IntStream.range(0, e.getCount()).mapToObj(i -> (IQTree)e.getElement())).collect(ImmutableCollectors.toList())).collect(ImmutableCollectors.toList());
            ImmutableList topUnionChildren = (ImmutableList)multiGroups.stream().map(g -> {
                switch (g.size()) {
                    case 0: {
                        throw new MinorOntopInternalBugException("Should not be empty");
                    }
                    case 1: {
                        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)initialAggregationNode, this.buildSubAggregateTree((IQTree)g.get(0), childConstructionNode, distinctDescendantNode, subConstructionDescendantNode));
                    }
                }
                NaryIQTree lowUnion = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(initialAggregationNode.getChildVariables()), g);
                return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)initialAggregationNode, this.buildSubAggregateTree((IQTree)lowUnion, childConstructionNode, distinctDescendantNode, subConstructionDescendantNode));
            }).map(t -> this.renameSomeUnprojectedVariables((IQTree)t, (Set<Variable>)nonGroupingVariables)).collect(ImmutableCollectors.toList());
            return this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(initialAggregationNode.getVariables()), topUnionChildren);
        }

        private IQTree buildSubAggregateTree(IQTree bottomTree, Optional<ConstructionNode> childConstructionNode, Optional<DistinctNode> distinctDescendantNode, Optional<ConstructionNode> subConstructionDescendantNode) {
            IQTree level3Tree = subConstructionDescendantNode.map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, bottomTree)).orElse(bottomTree);
            IQTree level2Tree = distinctDescendantNode.map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, level3Tree)).orElse(level3Tree);
            return childConstructionNode.map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, level2Tree)).orElse(level2Tree);
        }

        private IQTree renameSomeUnprojectedVariables(IQTree tree, Set<Variable> nonGroupingVariables) {
            InjectiveVar2VarSubstitution renaming = this.substitutionFactory.getInjectiveVar2VarSubstitution(nonGroupingVariables.stream(), arg_0 -> ((VariableGenerator)this.variableGenerator).generateNewVariableFromVar(arg_0));
            return tree.applyFreshRenamingToAllVariables(renaming);
        }
    }
}

