/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import net.sansa_stack.hadoop.util.SeekableDecorator;
import org.apache.hadoop.fs.Seekable;

public class SeekablePushbackInputStream
extends PushbackInputStream
implements SeekableDecorator {
    protected Seekable seekable;

    public SeekablePushbackInputStream(InputStream in, int size) {
        this(in, (Seekable)in, size);
    }

    public SeekablePushbackInputStream(InputStream in, Seekable seekable, int size) {
        super(in, size);
        this.seekable = seekable;
    }

    @Override
    public Seekable getSeekable() {
        return this.seekable;
    }

    protected void afterSeek() {
        this.pos = this.buf.length;
    }

    @Override
    public void seek(long l) throws IOException {
        this.getSeekable().seek(l);
        this.afterSeek();
    }

    @Override
    public boolean seekToNewSource(long l) throws IOException {
        boolean result = this.getSeekable().seekToNewSource(l);
        this.afterSeek();
        return result;
    }
}

