/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;

public class FileSystemUtils {
    public static InputStream newInputStream(Path path, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        return FileSystemUtils.newInputStream(path, fs, conf);
    }

    public static InputStream newInputStream(Path path, FileSystem fs, Configuration conf) throws IOException {
        CompressionCodecFactory compressionCodecFactory = new CompressionCodecFactory(conf);
        return FileSystemUtils.newInputStream(path, fs, compressionCodecFactory);
    }

    public static InputStream newInputStream(Path path, FileSystem fs, CompressionCodecFactory compressionCodecFactory) throws IOException {
        CompressionCodec codec;
        FSDataInputStream result = fs.open(path);
        if (compressionCodecFactory != null && null != (codec = compressionCodecFactory.getCodec(path))) {
            result = codec.createInputStream((InputStream)result);
        }
        return result;
    }
}

