/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.util;

import com.google.common.io.BaseEncoding;
import com.google.gson.Gson;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.hadoop.conf.Configuration;

public class ConfigurationUtils {
    public static <T> T getSerializable(Configuration conf, String key, T defaultValue) {
        String str = conf.get(key);
        Object result = defaultValue;
        if (str != null) {
            byte[] data = BaseEncoding.base64Url().omitPadding().decode((CharSequence)str);
            Object obj = SerializationUtils.deserialize((byte[])data);
            result = obj;
        }
        return result;
    }

    public static void setSerializable(Configuration conf, String key, Serializable serializable) {
        byte[] data = SerializationUtils.serialize((Serializable)serializable);
        String str = BaseEncoding.base64Url().omitPadding().encode(data);
        conf.set(key, str);
    }

    public static <T> T getJson(Configuration conf, Gson gson, String key, Class<T> clz, T defaultValue) {
        String str = conf.get(key);
        Object result = defaultValue;
        if (str != null) {
            Object obj = gson.fromJson(str, clz);
            result = obj;
        }
        return result;
    }

    public static void setJson(Configuration conf, Gson gson, String key, Object obj) {
        String str = gson.toJson(obj);
        conf.set(key, str);
    }
}

