/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.output.jena.base;

import java.io.OutputStream;
import java.util.function.Function;
import net.sansa_stack.hadoop.output.jena.base.FragmentOutputSpec;
import net.sansa_stack.hadoop.output.jena.base.OutputFormatBase;
import net.sansa_stack.hadoop.output.jena.base.RdfOutputUtils;
import net.sansa_stack.hadoop.output.jena.base.RecordWriterStreamRDF;
import net.sansa_stack.hadoop.output.jena.base.StreamRDFUtils;
import org.aksw.jenax.arq.util.prefix.PrefixMapTrie;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.shared.PrefixMapping;

public abstract class OutputFormatStreamRdfBase<T>
extends OutputFormatBase<T> {
    protected abstract void sendRecordToStreamRdf(StreamRDF var1, T var2);

    protected abstract RDFFormat getDefaultRdfFormat();

    @Override
    protected RecordWriter<Long, T> getRecordWriter(Configuration conf, OutputStream out, FragmentOutputSpec fragmentOutputSpec) {
        RDFFormat rdfFormat = this.getDefaultRdfFormat();
        rdfFormat = RdfOutputUtils.getRdfFormat(conf, rdfFormat);
        PrefixMapping prefixMap = RdfOutputUtils.getPrefixes(conf);
        boolean mapQuadsToTriplesForTripleLangs = RdfOutputUtils.getMapQuadsToTriplesForTripleLangs(conf);
        PrefixMapTrie p = new PrefixMapTrie();
        p.putAll(prefixMap);
        Function<OutputStream, StreamRDF> mapper = StreamRDFUtils.createStreamRDFFactory(rdfFormat, mapQuadsToTriplesForTripleLangs, (PrefixMap)p, fragmentOutputSpec);
        StreamRDF streamRdf = mapper.apply(out);
        RecordWriterStreamRDF<Object> result = new RecordWriterStreamRDF<Object>(streamRdf, this::sendRecordToStreamRdf, out::close);
        return result;
    }
}

