/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.output.jena.base;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.sansa_stack.hadoop.output.jena.base.FragmentOutputSpec;
import net.sansa_stack.hadoop.output.jena.base.OutputFormatBase;
import net.sansa_stack.hadoop.output.jena.base.RdfOutputUtils;
import net.sansa_stack.hadoop.output.jena.base.RecordWriterRowSetStream;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriter;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriterFactory;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriterRegistry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;

public class OutputFormatRowSet
extends OutputFormatBase<Binding> {
    protected Lang getDefaultResultSetLang() {
        return ResultSetLang.RS_TSV;
    }

    @Override
    protected RecordWriter<Long, Binding> getRecordWriter(Configuration conf, OutputStream out, FragmentOutputSpec fragmentOutputSpec) {
        RecordWriterRowSetStream result;
        Lang defaultLang = this.getDefaultResultSetLang();
        Lang lang = RdfOutputUtils.getLang(conf, defaultLang);
        Preconditions.checkArgument((lang != null ? 1 : 0) != 0, (Object)"No output language configured");
        List<Var> vars = RdfOutputUtils.getVars(conf);
        Preconditions.checkArgument((vars != null ? 1 : 0) != 0, (Object)"Result set variables not set");
        RowSetStreamWriterFactory factory = RowSetStreamWriterRegistry.getFactory((Lang)lang);
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (Object)("No result set writer registered for '" + String.valueOf(lang) + "'"));
        RowSetStreamWriter writer = factory.create(out, vars);
        try {
            result = new RecordWriterRowSetStream(writer, fragmentOutputSpec);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

