/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.format.univocity.csv.csv;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.record.Record;
import io.reactivex.rxjava3.core.Flowable;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.aksw.commons.lambda.throwing.ThrowingBiConsumer;
import org.aksw.commons.lambda.throwing.ThrowingFunction;
import org.aksw.commons.lambda.throwing.ThrowingSupplier;
import org.aksw.commons.model.csvw.univocity.UnivocityParserFactory;
import org.aksw.commons.rx.util.FlowableEx;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class UnivocityRxUtils {
    public static Flowable<Record> readCsvRecords(String path, FileSystem fileSystem, UnivocityParserFactory parserFactory) {
        return UnivocityRxUtils.readCsvRecords(new Path(path), fileSystem, parserFactory);
    }

    public static Flowable<Record> readCsvRecords(Path path, FileSystem fileSystem, UnivocityParserFactory parserFactory) {
        return UnivocityRxUtils.readCsvRecords(() -> fileSystem.open(path), parserFactory);
    }

    public static Flowable<String[]> readCsvRows(Path path, FileSystem fileSystem, UnivocityParserFactory parserFactory) {
        return UnivocityRxUtils.readCsvRecords(path, fileSystem, parserFactory).map(Record::getValues);
    }

    public static Flowable<String[]> readCsvRows(String path, FileSystem fileSystem, UnivocityParserFactory parserFactory) {
        return UnivocityRxUtils.readCsvRecords(path, fileSystem, parserFactory).map(Record::getValues);
    }

    public static Flowable<Record> readCsvRecords(Callable<? extends InputStream> inSupp, UnivocityParserFactory parserFactory) {
        return FlowableEx.fromEnumerableResource((ThrowingSupplier & Serializable)() -> parserFactory.newInputStreamReader((InputStream)inSupp.call()), (ThrowingFunction & Serializable)reader -> {
            AbstractParser r = parserFactory.newParser();
            r.beginParsing((Reader)reader);
            return r;
        }, (ThrowingFunction & Serializable)csvParser -> csvParser.parseNextRecord(), (ThrowingBiConsumer & Serializable)(in, csvParser) -> {
            if (in != null) {
                in.close();
            }
        });
    }
}

