/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.format.jena.base;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import net.sansa_stack.hadoop.core.Accumulating;
import net.sansa_stack.hadoop.core.RecordReaderGenericBase;
import net.sansa_stack.hadoop.format.jena.base.FileInputFormatRdfBase;
import net.sansa_stack.hadoop.format.jena.base.RecordReaderRdfConf;
import org.aksw.jenax.arq.util.irixresolver.IRIxResolverUtils;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrRx;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.riot.system.AsyncParserBuilder;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shared.PrefixMapping;

public abstract class RecordReaderGenericRdfBase<U, G, A, T>
extends RecordReaderGenericBase<U, G, A, T> {
    protected final String baseIriKey;
    protected final String headerBytesKey;
    protected String prefixesMaxLengthKey;
    protected String baseIri;
    protected Lang lang;
    protected PrefixMap prefixMap;

    public RecordReaderGenericRdfBase(RecordReaderRdfConf conf, Accumulating<U, G, A, T> accumulating) {
        super(conf, accumulating);
        this.lang = conf.getLang();
        this.prefixesMaxLengthKey = conf.getPrefixesMaxLengthKey();
        this.baseIriKey = "base";
        this.headerBytesKey = "prefixes";
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
        super.initialize(inputSplit, context);
        Configuration job = context.getConfiguration();
        this.baseIri = job.get(this.baseIriKey);
        Model model = FileInputFormatRdfBase.getModel(job, this.headerBytesKey);
        this.prefixMap = PrefixMapFactory.create((PrefixMapping)model);
    }

    protected AsyncParserBuilder setupParser(InputStream in, boolean isProbe) {
        AsyncParserBuilder result = AsyncParser.of((InputStream)in, (Lang)this.lang, (String)this.baseIri).mutateSources(parser -> parser.prefixes(this.prefixMap).labelToNode(RDFDataMgrRx.createLabelToNodeAsGivenOrRandom()).resolver(IRIxResolverUtils.newIRIxResolverAsGiven()));
        if (isProbe) {
            result = result.setChunkSize(1000).mutateSources(parser -> parser.errorHandler(ErrorHandlerFactory.errorHandlerSimple())).setPrematureDispatch(new CountingPredicate(this.probeRecordCount));
        }
        return result;
    }

    private static class CountingPredicate<T>
    implements Predicate<T> {
        protected long threshold;
        protected long currentValue = 0L;

        public CountingPredicate(long threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean test(T t) {
            return this.currentValue++ < this.threshold;
        }
    }
}

