/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.format.jena.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import net.sansa_stack.hadoop.format.jena.base.CanParseRdf;
import net.sansa_stack.hadoop.util.FileSplitUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.riot.system.EltStreamRDF;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDFBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileInputFormatRdfBase<T>
extends FileInputFormat<LongWritable, T>
implements CanParseRdf {
    private static final Logger logger = LoggerFactory.getLogger(FileInputFormatRdfBase.class);
    public static final String PREFIXES_KEY = "prefixes";
    public static final String BASE_IRI_KEY = "base";
    public static final long PARSED_PREFIXES_LENGTH_DEFAULT = 0x100000L;
    protected Lang lang;
    protected String prefixesLengthMaxKey;

    public FileInputFormatRdfBase(Lang lang, String prefixesLengthMaxKey) {
        this.lang = lang;
        this.prefixesLengthMaxKey = prefixesLengthMaxKey;
    }

    public boolean isSplitable(JobContext context, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        boolean result = codec == null || codec instanceof SplittableCompressionCodec;
        return result;
    }

    public final RecordReader<LongWritable, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext context) {
        if (context.getConfiguration().get(PREFIXES_KEY) == null) {
            logger.warn("couldn't get prefixes from Job context");
        }
        return this.createRecordReaderActual(inputSplit, context);
    }

    public abstract RecordReader<LongWritable, T> createRecordReaderActual(InputSplit var1, TaskAttemptContext var2);

    public static PrefixMap readPrefixesIntoModel(PrefixMap prefixModel, Callable<InputStream> inSupp, Lang lang, Long limit) {
        PrefixMap prefixMap;
        block8: {
            InputStream in = inSupp.call();
            try {
                PrefixMap result;
                prefixMap = result = FileInputFormatRdfBase.readPrefixesIntoModel(prefixModel, in, lang, limit);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return prefixMap;
    }

    public PrefixMap readPrefixes(Callable<InputStream> inSupp, Configuration conf) {
        long limit = this.getPrefixByteCount(conf);
        PrefixMap result = FileInputFormatRdfBase.readPrefixesIntoModel(null, inSupp, this.lang, (Long)limit);
        return result;
    }

    @Override
    public PrefixMap parsePrefixes(InputStream in, Configuration conf) {
        long limit = this.getPrefixByteCount(conf);
        PrefixMap result = FileInputFormatRdfBase.readPrefixesIntoModel(null, in, this.lang, (Long)limit);
        return result;
    }

    public static PrefixMap readPrefixesIntoModel(PrefixMap sink, InputStream in, Lang lang, Long limit) {
        if (limit != null && limit >= 0L) {
            in = new BoundedInputStream(in, limit.longValue());
        }
        return FileInputFormatRdfBase.readPrefixesIntoModel(sink, in, lang);
    }

    public long getPrefixByteCount(Configuration conf) {
        long result = this.prefixesLengthMaxKey == null ? 0L : conf.getLong(this.prefixesLengthMaxKey, 0x100000L);
        return result;
    }

    public static PrefixMap readPrefixesIntoModel(PrefixMap sink, InputStream in, Lang lang) {
        final PrefixMap dst = sink == null ? PrefixMapFactory.create() : sink;
        StreamRDFBase prefixSink = new StreamRDFBase(){

            public void prefix(String prefix, String iri) {
                dst.add(prefix, iri);
            }
        };
        try (Stream stream = AsyncParser.of((InputStream)in, (Lang)lang, null).setChunkSize(100).streamElements();){
            Iterator it = stream.iterator();
            long nonPrefixEventCount = 0L;
            long maxNonPrefixEventCount = 1000L;
            while (it.hasNext() && nonPrefixEventCount < maxNonPrefixEventCount) {
                EltStreamRDF event = (EltStreamRDF)it.next();
                if (event.isPrefix()) {
                    prefixSink.prefix(event.prefix(), event.iri());
                    nonPrefixEventCount = 0L;
                    continue;
                }
                ++nonPrefixEventCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dst;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        Configuration conf = job.getConfiguration();
        List splits = super.getSplits(job);
        if (!splits.isEmpty()) {
            FileSplit firstSplit = (FileSplit)splits.get(0);
            long prefixByteCount = this.getPrefixByteCount(conf);
            PrefixMap prefixMap = this.readPrefixes(() -> FileSplitUtils.getDecodedStreamFromSplit(firstSplit, conf), job.getConfiguration());
            int prefixCount = prefixMap.size();
            logger.info(String.format("Parsed %d prefixes from first %d bytes", prefixCount, prefixByteCount));
            Model prefixModel = ModelFactory.createDefaultModel();
            prefixModel.setNsPrefixes(prefixMap.getMapping());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            RDFDataMgr.write((OutputStream)baos, (Model)prefixModel, (RDFFormat)RDFFormat.TURTLE_PRETTY);
            conf.set(BASE_IRI_KEY, firstSplit.getPath().toString());
            conf.set(PREFIXES_KEY, baos.toString("UTF-8"));
        }
        return splits;
    }

    public static Model getModel(Configuration conf) {
        return FileInputFormatRdfBase.getModel(conf, PREFIXES_KEY);
    }

    public static Model getModel(Configuration conf, String key) {
        String str = conf.get(key);
        Model result = ModelFactory.createDefaultModel();
        if (str != null) {
            RDFDataMgr.read((Model)result, (StringReader)new StringReader(str), null, (Lang)Lang.TURTLE);
        }
        return result;
    }
}

