/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.format.gson.json;

import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.stream.Stream;
import net.sansa_stack.hadoop.core.Accumulating;
import net.sansa_stack.hadoop.core.RecordReaderGenericBase;
import net.sansa_stack.hadoop.core.pattern.CustomPattern;
import net.sansa_stack.hadoop.core.pattern.CustomPatternJava;
import net.sansa_stack.hadoop.format.gson.json.JsonElementSequenceIterator;
import net.sansa_stack.hadoop.format.jena.base.RecordReaderConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class RecordReaderJsonSequence
extends RecordReaderGenericBase<JsonElement, JsonElement, JsonElement, JsonElement> {
    public static final String RECORD_MINLENGTH_KEY = "mapreduce.input.json.record.minlength";
    public static final String RECORD_MAXLENGTH_KEY = "mapreduce.input.json.record.maxlength";
    public static final String RECORD_PROBECOUNT_KEY = "mapreduce.input.json.record.probecount";
    protected static final CustomPattern jsonFwdPattern = CustomPatternJava.compile("\\{|\\[|\"|\\d|\\.", 10);
    protected Gson gson;

    public RecordReaderJsonSequence() {
        this(new GsonBuilder().setLenient().create());
    }

    public RecordReaderJsonSequence(Gson gson) {
        this(new RecordReaderConf(null, RECORD_MINLENGTH_KEY, RECORD_MAXLENGTH_KEY, RECORD_PROBECOUNT_KEY, jsonFwdPattern), gson);
    }

    public RecordReaderJsonSequence(RecordReaderConf conf, Gson gson) {
        super(conf, Accumulating.identity());
        this.gson = gson;
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
        super.initialize(inputSplit, context);
    }

    @Override
    protected Stream<JsonElement> parse(InputStream in, boolean isProbe) {
        JsonElementSequenceIterator it = new JsonElementSequenceIterator(this.gson, this.gson.newJsonReader((Reader)new InputStreamReader(in)));
        return (Stream)Streams.stream((Iterator)((Object)it)).onClose(it::close);
    }
}

