/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.format.gson.json;

import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import io.reactivex.rxjava3.core.Flowable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import net.sansa_stack.hadoop.core.Accumulating;
import net.sansa_stack.hadoop.core.RecordReaderGenericBase;
import net.sansa_stack.hadoop.core.pattern.CustomPattern;
import net.sansa_stack.hadoop.core.pattern.CustomPatternJava;
import net.sansa_stack.hadoop.format.gson.json.JsonElementArrayIterator;
import net.sansa_stack.hadoop.format.jena.base.RecordReaderConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class RecordReaderJsonArray
extends RecordReaderGenericBase<JsonElement, JsonElement, JsonElement, JsonElement> {
    public static final String RECORD_MINLENGTH_KEY = "mapreduce.input.json.record.minlength";
    public static final String RECORD_MAXLENGTH_KEY = "mapreduce.input.json.record.maxlength";
    public static final String RECORD_PROBECOUNT_KEY = "mapreduce.input.json.record.probecount";
    protected static final CustomPattern jsonFwdPattern = CustomPatternJava.compile("\\[|,", 10);
    protected Gson gson;

    public RecordReaderJsonArray() {
        this(new GsonBuilder().setLenient().create());
    }

    public RecordReaderJsonArray(Gson gson) {
        this(new RecordReaderConf(null, RECORD_MINLENGTH_KEY, RECORD_MAXLENGTH_KEY, RECORD_PROBECOUNT_KEY, jsonFwdPattern), gson);
    }

    public RecordReaderJsonArray(RecordReaderConf conf, Gson gson) {
        super(conf, Accumulating.identity());
        this.gson = gson;
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
        super.initialize(inputSplit, context);
        this.postambleBytes = new byte[]{93};
    }

    @Override
    protected InputStream effectiveInputStream(InputStream base) {
        PushbackInputStream result = new PushbackInputStream(base);
        try {
            int c = result.read();
            if (c != -1) {
                result.unread(91);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    protected Stream<JsonElement> parse(InputStream in, boolean isProbe) {
        JsonElementArrayIterator it = new JsonElementArrayIterator(this.gson, this.gson.newJsonReader((Reader)new InputStreamReader(in)));
        return (Stream)Streams.stream((Iterator)((Object)it)).onClose(it::close);
    }

    protected Flowable<JsonElement> parse(Callable<InputStream> inputStreamSupplier) {
        return Flowable.generate(() -> new AbstractMap.SimpleEntry<JsonReader, Boolean>(this.gson.newJsonReader((Reader)new InputStreamReader((InputStream)inputStreamSupplier.call())), false), (s, e) -> {
            block12: {
                try {
                    boolean hasMore;
                    JsonReader reader = (JsonReader)s.getKey();
                    if (!((Boolean)s.getValue()).booleanValue()) {
                        s.setValue(true);
                        try {
                            reader.beginArray();
                        }
                        catch (EOFException x) {
                            e.onComplete();
                            return;
                        }
                    }
                    if (reader.hasNext()) {
                        JsonElement item = (JsonElement)this.gson.fromJson(reader, JsonElement.class);
                        e.onNext((Object)item);
                        break block12;
                    }
                    reader.endArray();
                    try {
                        hasMore = reader.hasNext();
                    }
                    catch (Exception y) {
                        hasMore = true;
                    }
                    if (hasMore) {
                        JsonElement nextItem = null;
                        try {
                            nextItem = (JsonElement)this.gson.fromJson(reader, JsonElement.class);
                        }
                        catch (IllegalArgumentException y) {
                            e.onComplete();
                        }
                        if (nextItem != null) {
                            throw new RuntimeException("More items found after array end: " + String.valueOf(nextItem));
                        }
                        break block12;
                    }
                    e.onComplete();
                }
                catch (Exception x) {
                    e.onError((Throwable)x);
                }
            }
        }, s -> ((JsonReader)s.getKey()).close());
    }
}

