/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.format.gson.json;

import com.google.common.collect.AbstractIterator;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import java.io.IOException;

public class JsonElementSequenceIterator
extends AbstractIterator<JsonElement>
implements AutoCloseable {
    protected Gson gson;
    protected JsonReader reader;

    public JsonElementSequenceIterator(Gson gson, JsonReader reader) {
        this.gson = gson;
        this.reader = reader;
    }

    protected JsonElement computeNext() {
        JsonElement result;
        try {
            result = this.reader.hasNext() ? (JsonElement)this.gson.fromJson(this.reader, JsonElement.class) : (JsonElement)this.endOfData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

