/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.format.commons_csv.csv;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.sansa_stack.hadoop.core.Accumulating;
import net.sansa_stack.hadoop.core.RecordReaderGenericBase;
import net.sansa_stack.hadoop.core.pattern.CustomPattern;
import net.sansa_stack.hadoop.core.pattern.CustomPatternJava;
import net.sansa_stack.hadoop.format.commons_csv.csv.FileInputFormatCsv;
import net.sansa_stack.hadoop.format.jena.base.RecordReaderConf;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordReaderCsv
extends RecordReaderGenericBase<List, List, List, List> {
    private static final Logger logger = LoggerFactory.getLogger(RecordReaderCsv.class);
    public static final String RECORD_MINLENGTH_KEY = "mapreduce.input.csv.record.minlength";
    public static final String RECORD_MAXLENGTH_KEY = "mapreduce.input.csv.record.maxlength";
    public static final String RECORD_PROBECOUNT_KEY = "mapreduce.input.csv.record.probecount";
    public static final String CSV_FORMAT_RAW_KEY = "mapreduce.input.csv.format.raw";
    public static final String CELL_MAXLENGTH_KEY = "mapreduce.input.csv.cell.maxlength";
    public static final long CELL_MAXLENGTH_DEFAULT_VALUE = 300000L;
    protected CSVFormat requestedCsvFormat;
    protected CSVFormat effectiveCsvFormat;

    public static CustomPattern createStartOfCsvRecordPattern(long n) {
        return CustomPatternJava.compile("(?<=\n(?!((?<![^\"]\"[^\"]).){0," + n + "}\"(\r?\n|,|$))).", 32);
    }

    public RecordReaderCsv() {
        this(new RecordReaderConf(null, RECORD_MINLENGTH_KEY, RECORD_MAXLENGTH_KEY, RECORD_PROBECOUNT_KEY, null));
    }

    public RecordReaderCsv(RecordReaderConf conf) {
        super(conf, Accumulating.identity());
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
        super.initialize(inputSplit, context);
        Configuration conf = context.getConfiguration();
        long cellMaxLength = conf.getLong(CELL_MAXLENGTH_KEY, 300000L);
        this.recordStartPattern = RecordReaderCsv.createStartOfCsvRecordPattern(cellMaxLength);
        this.requestedCsvFormat = FileInputFormatCsv.getCsvFormat(conf, CSVFormat.EXCEL);
        this.effectiveCsvFormat = this.disableSkipHeaderRecord(this.requestedCsvFormat);
    }

    protected CSVFormat disableSkipHeaderRecord(CSVFormat csvFormat) {
        return CSVFormat.Builder.create((CSVFormat)csvFormat).setSkipHeaderRecord(false).build();
    }

    protected CSVParser newCsvParser(Reader reader) throws IOException {
        return new CSVParser(reader, this.effectiveCsvFormat);
    }

    @Override
    protected Stream<List> createRecordFlow() throws IOException {
        Stream<List> tmp = super.createRecordFlow();
        if (this.requestedCsvFormat.getSkipHeaderRecord() && this.isFirstSplit) {
            tmp = tmp.skip(1L);
        }
        return tmp;
    }

    @Override
    protected Stream<List> parse(InputStream in, boolean isProbe) {
        State it = new State(new InputStreamReader(in), this.effectiveCsvFormat);
        return (Stream)Streams.stream((Iterator)((Object)it)).onClose(it::close);
    }

    private static class State
    extends AbstractIterator<List>
    implements AutoCloseable {
        public Reader reader;
        public CSVFormat effectiveCsvFormat;
        public CSVParser csvParser = null;
        public Iterator<CSVRecord> iterator;
        public long seenRowLength = -1L;
        public List<String> priorRow = null;
        public long counter = 0L;

        State(Reader reader, CSVFormat effectiveCsvFormat) {
            this.reader = reader;
            this.effectiveCsvFormat = effectiveCsvFormat;
        }

        protected List computeNext() {
            List result;
            Iterator it = this.iterator;
            if (it == null) {
                try {
                    this.csvParser = new CSVParser(this.reader, this.effectiveCsvFormat);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                it = this.iterator = this.csvParser.iterator();
            }
            if (!it.hasNext()) {
                result = (List)this.endOfData();
            } else {
                CSVRecord csvRecord = it.next();
                List row = csvRecord.toList();
                ++this.counter;
                long rowLength = row.size();
                if (this.seenRowLength == -1L) {
                    this.seenRowLength = rowLength;
                } else if (rowLength != this.seenRowLength) {
                    String msg = String.format("At row %d: Current row length (%d) does not match prior one (%d) - current: %s | prior: %s", this.counter, rowLength, this.seenRowLength, row, this.priorRow);
                    throw new IllegalStateException(msg);
                }
                this.priorRow = row;
                result = row;
            }
            return result;
        }

        @Override
        public void close() {
            try {
                if (this.csvParser != null) {
                    this.csvParser.close();
                } else {
                    this.reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

