/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.input.ProxyInputStream;

public class InputStreamWithCloseLogging
extends ProxyInputStream {
    protected Throwable creationStackTrace = new Throwable();
    protected BiConsumer<? super Throwable, ? super Throwable> stackTraceConsumer;

    public InputStreamWithCloseLogging(InputStream proxy, BiConsumer<? super Throwable, ? super Throwable> stackTraceConsumer) {
        super(proxy);
        this.stackTraceConsumer = stackTraceConsumer;
    }

    public void close() throws IOException {
        Throwable closingStackTrace = new Throwable();
        this.stackTraceConsumer.accept(this.creationStackTrace, closingStackTrace);
        super.close();
    }

    public static InputStream wrap(InputStream proxy, Function<? super Throwable, String> toString, Consumer<? super String> logger) {
        return new InputStreamWithCloseLogging(proxy, (creation, closing) -> {
            String creationStr = (String)toString.apply((Throwable)creation);
            String closingStr = (String)toString.apply((Throwable)closing);
            String msg = "Closing stream created at:\n" + creationStr + " with close called at:\n" + closingStr;
            logger.accept(msg);
        });
    }
}

