/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import net.sansa_stack.hadoop.util.SeekableDecorator;
import org.apache.hadoop.fs.Seekable;

public class DeferredSeekablePushbackInputStream
extends PushbackInputStream
implements SeekableDecorator {
    protected Seekable seekable;
    private static final int TRANSFER_SIZE = 8193;
    protected ReadMode readMode = ReadMode.BUFFERED;
    protected byte[] fallbackBuffer = new byte[8193];

    public DeferredSeekablePushbackInputStream(InputStream in) {
        this(in, (Seekable)in);
    }

    public DeferredSeekablePushbackInputStream(InputStream in, Seekable seekable) {
        super(in, 1);
        this.seekable = seekable;
    }

    @Override
    public Seekable getSeekable() {
        return this.seekable;
    }

    @Override
    public int read() throws IOException {
        int result = this.read(this.fallbackBuffer, 0, 2);
        if (result > 0) {
            result = this.fallbackBuffer[0];
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        boolean isBufferedRead;
        int l;
        int o;
        byte[] out;
        if (len == 0) {
            return 0;
        }
        if (len == 1) {
            out = this.fallbackBuffer;
            o = 0;
            l = 2;
            isBufferedRead = true;
        } else {
            switch (this.readMode) {
                case BUFFERED: {
                    int bytesToRead = Math.min(len + 1, 8193);
                    out = this.fallbackBuffer;
                    o = 0;
                    l = bytesToRead;
                    isBufferedRead = true;
                    break;
                }
                case UNSAFE: {
                    out = b;
                    o = off;
                    l = len;
                    isBufferedRead = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown read mode: " + String.valueOf((Object)this.readMode));
                }
            }
        }
        int n = 0;
        while (n == 0) {
            n = this.readInternal(out, o, l);
        }
        if (n > 0 && isBufferedRead) {
            System.arraycopy(this.fallbackBuffer, 0, b, off, n);
        }
        return n;
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
    }

    protected int readInternal(byte[] b, int off, int len) throws IOException {
        int result;
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
        int avail = this.buf.length - this.pos;
        int n = super.read(b, off, len);
        if (n == avail || n < 0) {
            result = n;
        } else {
            result = n - 1;
            byte lastByte = b[result];
            this.unread(lastByte);
        }
        return result;
    }

    protected void afterSeek() {
        this.pos = this.buf.length;
    }

    @Override
    public void seek(long l) throws IOException {
        this.seekable.seek(l);
        this.afterSeek();
    }

    @Override
    public long getPos() throws IOException {
        return this.seekable.getPos();
    }

    @Override
    public boolean seekToNewSource(long l) throws IOException {
        boolean result = this.seekable.seekToNewSource(l);
        this.afterSeek();
        return result;
    }

    private static enum ReadMode {
        UNSAFE,
        BUFFERED;

    }
}

