/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.output.jena.base;

import java.io.OutputStream;
import java.util.function.Function;
import net.sansa_stack.hadoop.output.jena.base.FragmentOutputSpec;
import org.aksw.jenax.arq.util.prefix.PrefixMapAdapter;
import org.aksw.jenax.arq.util.prefix.PrefixMappingTrie;
import org.aksw.jenax.arq.util.streamrdf.WriterStreamRDFBaseUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.riot.writer.WriterStreamRDFBase;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Quad;

public class StreamRDFUtils {
    public static Function<OutputStream, StreamRDF> createStreamRDFFactory(RDFFormat rdfFormat, boolean mapQuadsToTriplesForTripleLangs, PrefixMap prefixMap, FragmentOutputSpec fragmentOutputSpec) {
        return out -> {
            Object rawWriter = StreamRDFWriter.getWriterStream((OutputStream)out, (RDFFormat)rdfFormat, null);
            StreamRDF coreWriter = org.aksw.jenax.arq.util.streamrdf.StreamRDFUtils.unwrap((StreamRDF)rawWriter);
            if (coreWriter instanceof WriterStreamRDFBase) {
                WriterStreamRDFBase tmp = (WriterStreamRDFBase)coreWriter;
                WriterStreamRDFBaseUtils.setNodeToLabel((WriterStreamRDFBase)tmp, (NodeToLabel)SyntaxLabels.createNodeToLabelAsGiven());
                if (prefixMap != null && !fragmentOutputSpec.isEmitHead()) {
                    WriterStreamRDFBaseUtils.setPrefixMap((WriterStreamRDFBase)tmp, (PrefixMap)prefixMap);
                } else {
                    WriterStreamRDFBaseUtils.setPrefixMap((WriterStreamRDFBase)tmp, (PrefixMap)new PrefixMapAdapter((PrefixMapping)new PrefixMappingTrie()));
                }
                WriterStreamRDFBaseUtils.updateFormatter((WriterStreamRDFBase)tmp);
            }
            if (RDFLanguages.isTriples((Lang)rdfFormat.getLang()) && mapQuadsToTriplesForTripleLangs) {
                rawWriter = new StreamRDFWrapper((StreamRDF)rawWriter){

                    public void quad(Quad quad) {
                        super.triple(quad.asTriple());
                    }
                };
            }
            rawWriter.start();
            if (fragmentOutputSpec.isEmitHead()) {
                StreamRDFOps.sendPrefixesToStream((PrefixMap)prefixMap, (StreamRDF)rawWriter);
            }
            rawWriter = org.aksw.jenax.arq.util.streamrdf.StreamRDFUtils.wrapWithoutPrefixDelegation((StreamRDF)rawWriter);
            return rawWriter;
        };
    }
}

