/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.output.jena.base;

import java.io.IOException;
import net.sansa_stack.hadoop.output.jena.base.FragmentOutputSpec;
import net.sansa_stack.hadoop.output.jena.base.RowSetStreamWriterUtils;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.sparql.engine.binding.Binding;

public class RecordWriterRowSetStream
extends RecordWriter<Long, Binding> {
    protected RowSetStreamWriter writer;
    protected FragmentOutputSpec fragmentOutputSpec;
    boolean hasPreviousBinding;

    public RecordWriterRowSetStream(RowSetStreamWriter writer, FragmentOutputSpec fragmentOutputSpec) throws IOException {
        this.writer = writer;
        this.fragmentOutputSpec = fragmentOutputSpec;
        this.hasPreviousBinding = RowSetStreamWriterUtils.init(writer, fragmentOutputSpec);
    }

    public void write(Long aLong, Binding record) throws IOException, InterruptedException {
        if (this.hasPreviousBinding) {
            this.writer.writeBindingSeparator();
        }
        this.writer.writeBinding(record);
        this.hasPreviousBinding = true;
    }

    public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        try {
            if (this.fragmentOutputSpec.isEmitTail()) {
                this.writer.endBindings();
                this.writer.writeFooter();
            }
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

