/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.format.gson.json;

import com.google.common.collect.AbstractIterator;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.EOFException;
import java.io.IOException;

public class JsonElementArrayIterator
extends AbstractIterator<JsonElement>
implements AutoCloseable {
    protected Gson gson;
    protected JsonReader reader;
    protected boolean isFirstElt;

    public JsonElementArrayIterator(Gson gson, JsonReader reader) {
        this.gson = gson;
        this.reader = reader;
        this.isFirstElt = false;
    }

    protected JsonElement computeNext() {
        JsonElement result;
        block14: {
            try {
                boolean hasMore;
                if (!this.isFirstElt) {
                    this.isFirstElt = true;
                    try {
                        this.reader.beginArray();
                    }
                    catch (EOFException x) {
                        JsonElement result2 = (JsonElement)this.endOfData();
                        return result2;
                    }
                }
                if (this.reader.hasNext()) {
                    JsonElement item;
                    result = item = (JsonElement)this.gson.fromJson(this.reader, JsonElement.class);
                    break block14;
                }
                this.reader.endArray();
                try {
                    hasMore = this.reader.hasNext();
                }
                catch (Exception y) {
                    hasMore = true;
                }
                if (hasMore) {
                    JsonElement nextItem = null;
                    JsonToken token = this.reader.peek();
                    if (token.equals((Object)JsonToken.END_DOCUMENT)) {
                        result = (JsonElement)this.endOfData();
                    } else {
                        try {
                            nextItem = (JsonElement)this.gson.fromJson(this.reader, JsonElement.class);
                        }
                        catch (IllegalArgumentException y) {
                            result = (JsonElement)this.endOfData();
                        }
                    }
                    if (nextItem != null) {
                        throw new RuntimeException("More items found after array end: " + String.valueOf(nextItem));
                    }
                    result = null;
                    break block14;
                }
                result = (JsonElement)this.endOfData();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

