/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.core.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sansa_stack.hadoop.core.pattern.CustomMatcher;
import net.sansa_stack.hadoop.core.pattern.CustomMatcherDecorator;
import net.sansa_stack.hadoop.core.pattern.CustomPattern;
import net.sansa_stack.hadoop.core.pattern.CustomPatternDecoratorBase;

public class CustomPatternReplay
extends CustomPatternDecoratorBase {
    protected CustomPatternReplay(CustomPattern decoratee) {
        super(decoratee);
    }

    public static CustomPatternReplay wrap(CustomPattern decoratee) {
        return new CustomPatternReplay(decoratee);
    }

    @Override
    public CustomMatcherReplay matcher(CharSequence charSequence) {
        CustomMatcher matcher = this.pattern.matcher(charSequence);
        return new CustomMatcherReplay(matcher);
    }

    public static class CustomMatcherReplay
    extends CustomMatcherDecorator {
        protected CustomMatcher decoratee;
        protected List<Match> matches = new ArrayList<Match>();
        protected int matchId;
        protected boolean isFinished = false;

        public CustomMatcherReplay(CustomMatcher decoratee) {
            this.decoratee = decoratee;
            this.reset();
        }

        public void reset() {
            this.matchId = -1;
        }

        @Override
        protected CustomMatcher getDecoratee() {
            return this.decoratee;
        }

        @Override
        public boolean find() {
            boolean result = false;
            if (this.matchId + 1 < this.matches.size()) {
                ++this.matchId;
                result = true;
            } else if (!this.isFinished) {
                result = super.find();
                if (result) {
                    int n = this.decoratee.groupCount();
                    Region[] regions = new Region[n];
                    for (int i = 0; i < n; ++i) {
                        regions[i] = new Region(this.decoratee.start(i), this.decoratee.end(i));
                    }
                    Match match = new Match();
                    match.groups = regions;
                    this.matches.add(match);
                    ++this.matchId;
                } else {
                    this.isFinished = true;
                }
            }
            return result;
        }

        @Override
        public int start() {
            return this.start(0);
        }

        @Override
        public int end() {
            return this.end(0);
        }

        @Override
        public int start(int group) {
            return this.matches.get((int)this.matchId).groups[group].start;
        }

        @Override
        public int end(int group) {
            return this.matches.get((int)this.matchId).groups[group].end;
        }

        @Override
        public int groupCount() {
            return this.matches.get((int)this.matchId).groups.length;
        }

        @Override
        public void region(int start, int end) {
            throw new UnsupportedOperationException();
        }

        private Region getOrCacheRegion(String name) {
            Region result = this.matches.get(this.matchId).namedGroups().computeIfAbsent(name, k -> {
                if (this.matchId + 1 != this.matches.size()) {
                    throw new IllegalStateException("Replayed match has no cached entry for group with name " + name);
                }
                return new Region(this.decoratee.start(name), this.decoratee.end(name));
            });
            return result;
        }

        @Override
        public int start(String name) {
            return this.getOrCacheRegion((String)name).start;
        }

        @Override
        public int end(String name) {
            return this.getOrCacheRegion((String)name).end;
        }
    }

    public static class Region {
        int start;
        int end;

        public Region(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "Region [start=" + this.start + ", end=" + this.end + "]";
        }
    }

    public static class Match {
        protected Region[] groups;
        protected Map<String, Region> namedGroups = null;

        public Map<String, Region> namedGroups() {
            if (this.namedGroups == null) {
                this.namedGroups = new HashMap<String, Region>();
            }
            return this.namedGroups;
        }
    }
}

