/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.core.pattern;

import java.util.regex.Pattern;
import net.sansa_stack.hadoop.core.pattern.CharSequenceReverse;
import net.sansa_stack.hadoop.core.pattern.CustomMatcher;
import net.sansa_stack.hadoop.core.pattern.CustomMatcherBase;
import net.sansa_stack.hadoop.core.pattern.CustomPattern;
import net.sansa_stack.hadoop.core.pattern.CustomPatternFiltered;
import net.sansa_stack.hadoop.core.pattern.CustomPatternJava;

@Deprecated
public class CustomPatternCsvOld
implements CustomPattern {
    protected int columnMaxLength;
    protected CustomPattern firstCharOnNewLinePattern;
    protected CustomPattern endOfQuotedFieldFwdPattern;
    protected CustomPattern startOfQuotedFieldBwdPattern;

    public static CustomPattern createFwdQuotePattern(Config dialect) {
        String patternStr = "(quote)(?=((term)|(delim)|$))";
        String str = CustomPatternCsvOld.substitute(patternStr, dialect);
        return CustomPatternJava.compile(str, 40);
    }

    public static CustomPattern createBwdPatternClosingQuote(Config dialect) {
        String patternStr = "(quote)(?=((term)|(delim)|$))";
        String str = CustomPatternCsvOld.substitute(patternStr, dialect);
        CustomPatternJava result = CustomPatternJava.compile(str, 40);
        return result;
    }

    public static CustomPattern createBwdPatternClosingQuote2(Config dialect) {
        String patternStr = "(quote)(?=((term)|(delim)|$))";
        String str = CustomPatternCsvOld.substitute(patternStr, dialect);
        CustomPatternJava result = CustomPatternJava.compile(str, 40);
        return result;
    }

    public static CustomPattern createIsEscapedBwdPattern(Config dialect) {
        String isEscapedBwdPatternStr = "^((esc)(esc))*(esc)([^(esc)]|$)";
        String str = CustomPatternCsvOld.substitute(isEscapedBwdPatternStr, dialect);
        return CustomPatternJava.compile(str, 40);
    }

    public static String substitute(String patternStr, Config dialect) {
        String str = patternStr;
        str = str.replace("(esc)", Pattern.quote(Character.toString(dialect.getEscapeChar())));
        str = str.replace("(quote)", Pattern.quote(Character.toString(dialect.getQuoteChar())));
        str = str.replace("(delim)", dialect.getDelimiter());
        str = str.replace("(term)", dialect.getLineTerminatorPattern());
        str = str.replace("(nesc)", Integer.toString(dialect.getMaxConsecutiveEscapeChars()));
        return str;
    }

    public static CustomPattern createFwdQuotePatternOld(Config dialect) {
        String patternStr = "(?<!((?<!(esc))((esc)(esc)){0,(nesc)})(esc))(quote)((term)|(delim)|$)";
        String str = CustomPatternCsvOld.substitute(patternStr, dialect);
        return CustomPatternJava.compile(str, 40);
    }

    public static CustomPatternCsvOld create(Config dialect) {
        CustomPattern startOfQuotedFieldBwdPattern;
        CustomPatternFiltered endOfQuotedFieldFwdPattern;
        char escapeChar;
        String str = "(?<=" + dialect.getLineTerminatorPattern() + ").";
        CustomPatternJava firstCharOnNewLinePattern = CustomPatternJava.compile(str, 32);
        char quoteChar = dialect.getQuoteChar();
        if (quoteChar == (escapeChar = dialect.getEscapeChar())) {
            startOfQuotedFieldBwdPattern = endOfQuotedFieldFwdPattern = new CustomPatternFiltered(CustomPatternCsvOld.createFwdQuotePattern(dialect), CustomPatternCsvOld.createIsEscapedBwdPattern(dialect));
        } else {
            endOfQuotedFieldFwdPattern = new CustomPatternFiltered(CustomPatternCsvOld.createFwdQuotePattern(dialect), CustomPatternCsvOld.createIsEscapedBwdPattern(dialect));
            startOfQuotedFieldBwdPattern = CustomPatternCsvOld.createBwdPatternClosingQuote(dialect);
        }
        return new CustomPatternCsvOld(dialect.getColumnMaxLength(), firstCharOnNewLinePattern, endOfQuotedFieldFwdPattern, startOfQuotedFieldBwdPattern);
    }

    public CustomPatternCsvOld(int columnMaxLength, CustomPattern firstCharAfterNewlinePattern, CustomPattern endOfQuotedFieldFwdPattern, CustomPattern startOfQuotedFieldBwdPattern) {
        this.firstCharOnNewLinePattern = firstCharAfterNewlinePattern;
        this.endOfQuotedFieldFwdPattern = endOfQuotedFieldFwdPattern;
        this.startOfQuotedFieldBwdPattern = startOfQuotedFieldBwdPattern;
        this.columnMaxLength = columnMaxLength;
    }

    @Override
    public CustomMatcher matcher(CharSequence charSequence) {
        return new CustomMatcherCsv(charSequence);
    }

    public static class Config {
        protected char quoteChar;
        protected char escapeChar;
        protected String delimiter;
        protected String lineTerminatorPattern;
        protected int maxConsecutiveEscapeChars;
        protected int columnMaxLength;

        public Config(char quoteChar, char escapeChar, String delimiter, String lineTerminatorPattern, int columnMaxLength, int maxConsecutiveEscapeChars) {
            this.quoteChar = quoteChar;
            this.escapeChar = escapeChar;
            this.delimiter = delimiter;
            this.lineTerminatorPattern = lineTerminatorPattern;
            this.columnMaxLength = columnMaxLength;
            this.maxConsecutiveEscapeChars = maxConsecutiveEscapeChars;
        }

        public static Config createExcel(int columnMaxLength) {
            return Config.create('\"', columnMaxLength);
        }

        public static Config create(char quoteChar, int columnMaxLength) {
            return Config.create(quoteChar, quoteChar, columnMaxLength);
        }

        public static Config create(char quoteChar, char escapeChar, int columnMaxLength) {
            return new Config(quoteChar, escapeChar, Pattern.quote(","), "\r?\n\r?", columnMaxLength, 32);
        }

        public char getQuoteChar() {
            return this.quoteChar;
        }

        public char getEscapeChar() {
            return this.escapeChar;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public String getLineTerminatorPattern() {
            return this.lineTerminatorPattern;
        }

        public int getMaxConsecutiveEscapeChars() {
            return this.maxConsecutiveEscapeChars;
        }

        public int getColumnMaxLength() {
            return this.columnMaxLength;
        }
    }

    public class CustomMatcherCsv
    extends CustomMatcherBase {
        protected int newlineMatchStart;
        protected boolean nextQuoteExamined;
        protected int nextQuoteEnd;
        protected int nextQuoteStart;

        public CustomMatcherCsv(CharSequence charSequence) {
            super(charSequence);
            this.newlineMatchStart = -1;
            this.nextQuoteExamined = false;
            this.nextQuoteEnd = -1;
            this.nextQuoteStart = -1;
        }

        @Override
        public boolean find() {
            int firstCharPos;
            block5: {
                if (this.pos < 0) {
                    return false;
                }
                CustomMatcher firstCharOnNewLineMatcher = CustomPatternCsvOld.this.firstCharOnNewLinePattern.matcher(this.charSequence);
                firstCharOnNewLineMatcher.region(this.pos, this.regionEnd);
                firstCharPos = -1;
                while (firstCharOnNewLineMatcher.find()) {
                    firstCharPos = firstCharOnNewLineMatcher.start();
                    if (firstCharPos < this.nextQuoteStart) break block5;
                    if (firstCharPos < this.nextQuoteEnd) {
                        this.nextQuoteExamined = false;
                        this.pos = this.nextQuoteEnd + 1;
                        int requestedLength = this.regionEnd - this.pos;
                        int relPos = this.pos - this.regionStart;
                        int allowedLength = Math.min(requestedLength, CustomPatternCsvOld.this.columnMaxLength - relPos);
                        firstCharOnNewLineMatcher.region(this.pos, this.pos + allowedLength);
                        continue;
                    }
                    if (this.nextQuoteExamined) break block5;
                    CustomMatcher endMatcher = CustomPatternCsvOld.this.endOfQuotedFieldFwdPattern.matcher(this.charSequence);
                    endMatcher.region(firstCharPos, this.regionEnd);
                    if (!endMatcher.find()) break block5;
                    this.nextQuoteEnd = endMatcher.start();
                    int reverseRegionStart = this.nextQuoteEnd - 1;
                    int reverseSearchLength = reverseRegionStart - firstCharPos;
                    CharSequenceReverse reverse = new CharSequenceReverse(this.charSequence, reverseRegionStart);
                    CustomMatcher startMatcher = CustomPatternCsvOld.this.startOfQuotedFieldBwdPattern.matcher(reverse);
                    startMatcher.region(0, reverseSearchLength);
                    if (startMatcher.find()) {
                        int reverseMatchStart = startMatcher.start();
                        this.nextQuoteStart = this.nextQuoteEnd - reverseMatchStart;
                    }
                    if (this.nextQuoteStart > firstCharPos) {
                        this.pos = firstCharPos + 1;
                        break block5;
                    }
                    this.pos = this.nextQuoteEnd + 1;
                    this.nextQuoteExamined = false;
                    firstCharOnNewLineMatcher.region(this.pos, this.regionEnd);
                }
                firstCharPos = -1;
            }
            boolean result = firstCharPos != -1;
            this.newlineMatchStart = firstCharPos;
            this.pos = !result ? -1 : firstCharPos + 1;
            return result;
        }

        @Override
        public int start() {
            return this.newlineMatchStart;
        }

        @Override
        public int end() {
            return this.newlineMatchStart + 1;
        }

        @Override
        public String group() {
            if (this.newlineMatchStart < 0) {
                throw new IllegalStateException("No match found");
            }
            String result = Character.toString(this.charSequence.charAt(this.newlineMatchStart));
            return result;
        }
    }
}

