/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.core.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sansa_stack.hadoop.core.pattern.CharSequences;
import net.sansa_stack.hadoop.core.pattern.CustomMatcherBase;
import net.sansa_stack.hadoop.core.pattern.CustomPattern;
import net.sansa_stack.hadoop.core.pattern.CustomPatternJava;
import net.sansa_stack.hadoop.core.pattern.CustomPatternReplay;
import org.aksw.commons.model.csvw.domain.api.Dialect;
import org.aksw.commons.model.csvw.domain.api.DialectMutable;
import org.aksw.commons.model.csvw.domain.impl.CsvwLib;
import org.aksw.commons.model.csvw.domain.impl.DialectMutableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPatternCsv
implements CustomPattern {
    private static final Logger logger = LoggerFactory.getLogger(CustomPatternCsv.class);
    protected Dialect dialect;
    protected CustomPattern fieldSeparatorAndNewlinePattern;
    protected int multilineFieldMaxLines;
    protected int cellMaxLength;

    public static Pattern createPattern(Dialect dialect) {
        List ts = dialect.getLineTerminatorList();
        if (ts == null || ts.isEmpty()) {
            ts = CsvwLib.DFT_LINE_TERMINATORS;
        }
        String fieldSeparator = Optional.ofNullable(dialect.getDelimiter()).orElse(",");
        String patternStr = "(?<lineTerminator>" + ts.stream().map(x -> "(" + Pattern.quote(x) + ")").collect(Collectors.joining("|")) + ")|(?<endOfData>$)|(?<fieldSeparator>" + Pattern.quote(fieldSeparator) + ")";
        return Pattern.compile(patternStr, 40);
    }

    public static CustomPattern create(int multilineFieldMaxLines) {
        return CustomPatternCsv.create(null, multilineFieldMaxLines, Integer.MAX_VALUE);
    }

    public static CustomPattern create(Dialect dialect, int multilineFieldMaxLines, int cellMaxLength) {
        DialectMutableImpl copy = new DialectMutableImpl();
        dialect.copyInto((DialectMutable)copy, true);
        CsvwLib.buildEffectiveModel((Dialect)dialect, (DialectMutable)copy);
        return new CustomPatternCsv(dialect, multilineFieldMaxLines, cellMaxLength);
    }

    protected CustomPatternCsv(Dialect dialect, int multilineFieldMaxLines, int cellMaxLength) {
        this.dialect = dialect;
        this.fieldSeparatorAndNewlinePattern = new CustomPatternJava(CustomPatternCsv.createPattern(dialect));
        this.multilineFieldMaxLines = multilineFieldMaxLines;
        this.cellMaxLength = cellMaxLength;
    }

    @Override
    public CustomMatcherCsv2 matcher(CharSequence charSequence) {
        return new CustomMatcherCsv2(charSequence);
    }

    public static boolean isPrecededByEffectiveQuote(CharSequence cs, int offset, int minOffset, char quoteChar, char escapeChar) {
        boolean result = CustomPatternCsv.isEffectiveQuoteBwd(cs, offset - 1, minOffset, quoteChar, escapeChar);
        return result;
    }

    public static boolean isFollowedByEffectiveQuote(CharSequence cs, int offset, char quoteChar, char escapeChar) {
        boolean result = CustomPatternCsv.isEffectiveQuoteFwd(cs, offset + 1, quoteChar, escapeChar);
        return result;
    }

    public static boolean isEffectiveQuoteFwd(CharSequence cs, int offset, char quoteChar, char escapeChar) {
        char c;
        boolean result = false;
        int i = offset;
        int n = cs.length();
        if (i < n && (c = cs.charAt(i)) == quoteChar) {
            ++i;
            if (quoteChar == escapeChar) {
                while (i < n && cs.charAt(i) == quoteChar) {
                    ++i;
                }
                int delta = i - offset;
                result = (delta & 1) == 1;
            } else {
                result = true;
            }
        }
        return result;
    }

    public static boolean isEffectiveQuoteBwd(CharSequence cs, int offset, int minOffset, char quoteChar, char escapeChar) {
        char c;
        boolean result = false;
        int i = offset;
        if (i >= minOffset && (c = cs.charAt(i)) == quoteChar) {
            --i;
            while (i >= minOffset && cs.charAt(i) == escapeChar) {
                --i;
            }
            int delta = i - offset;
            result = (delta & 1) == 1;
        }
        return result;
    }

    public static void mainX(String[] args) {
        System.out.println(CustomPatternCsv.isPrecededByEffectiveQuote("a,\"\"\",", 6, 3, '\"', '\"'));
        System.out.println(CustomPatternCsv.isPrecededByEffectiveQuote("a,\"\"\"\",", 6, 3, '\"', '\"'));
        System.out.println(CustomPatternCsv.isFollowedByEffectiveQuote(".\"", 0, '\"', '\"'));
        System.out.println(CustomPatternCsv.isFollowedByEffectiveQuote("a.\"\"", 1, '\"', '\"'));
        System.out.println(CustomPatternCsv.isPrecededByEffectiveQuote("\"\".", 2, 0, '\"', '\"'));
        System.out.println(CustomPatternCsv.isPrecededByEffectiveQuote("\".", 1, 0, '\"', '\"'));
    }

    public static void autoDetectStartInQuotedField(CustomMatcherCsv2 matcher, int rowProbeCount) {
        int verdict = -1;
        block0: for (int r = 0; r <= 1; ++r) {
            int i;
            boolean quoted = r != 0;
            matcher.setInQuotedField(quoted);
            matcher.reset();
            int lastFieldCount = -1;
            for (i = 0; i < rowProbeCount && matcher.find(); ++i) {
                int n = matcher.getLastMatchedFields().size();
                int quoteErrorCount = matcher.getQuoteErrorCount();
                if (logger.isDebugEnabled()) {
                    logger.debug("quoteErrorCount: " + quoteErrorCount);
                }
                if (lastFieldCount == -1) {
                    lastFieldCount = n;
                }
                if (lastFieldCount == n && quoteErrorCount <= 0) continue;
                verdict = 2;
                continue block0;
            }
            if (i <= 0 && rowProbeCount != 0) continue;
            verdict = r;
            break;
        }
        if (verdict == 2) {
            throw new IllegalStateException("Could not decide whether position is inside or outside of a quoted field because either assumption led to quote errors and/or sample of rows having varying lengths");
        }
        matcher.reset();
        matcher.setInQuotedField(verdict == 1);
    }

    public class CustomMatcherCsv2
    extends CustomMatcherBase {
        protected CustomPatternReplay.CustomMatcherReplay fieldSeparatorAndNewlineMatcher;
        protected int quoteErrorCount;
        protected List<CharSequence> lastMatchedFields;
        protected int currentFieldContentStart;
        protected Boolean isInQuotedField;
        protected int currentLineCount;
        protected int lastRowEnd;
        protected int lastRowStart;

        public CustomMatcherCsv2(CharSequence charSequence) {
            super(charSequence);
            this.quoteErrorCount = 0;
            this.lastMatchedFields = new ArrayList<CharSequence>();
            this.currentFieldContentStart = 0;
            this.isInQuotedField = null;
            this.lastRowEnd = 0;
            this.lastRowStart = 0;
            this.fieldSeparatorAndNewlineMatcher = CustomPatternReplay.wrap(CustomPatternCsv.this.fieldSeparatorAndNewlinePattern).matcher(charSequence);
        }

        public List<CharSequence> getLastMatchedFields() {
            return this.lastMatchedFields;
        }

        public int getQuoteErrorCount() {
            return this.quoteErrorCount;
        }

        @Override
        public boolean find() {
            boolean result;
            while ((result = this.findNext()) && this.lastRowStart == 0) {
            }
            return result;
        }

        public boolean findNext() {
            boolean result = false;
            char quoteChar = CsvwLib.expectAtMostOneChar((String)"quote char", (String)CustomPatternCsv.this.dialect.getQuoteChar(), (Character)Character.valueOf('\"')).charValue();
            char escapeChar = CsvwLib.expectAtMostOneChar((String)"escape char", (String)CustomPatternCsv.this.dialect.getQuoteEscapeChar(), (Character)Character.valueOf('\"')).charValue();
            this.lastMatchedFields.clear();
            this.quoteErrorCount = 0;
            if (this.pos < 0) {
                return false;
            }
            if (this.isInQuotedField == null) {
                CustomPatternCsv.autoDetectStartInQuotedField(this, CustomPatternCsv.this.multilineFieldMaxLines);
            }
            int lastMatchEnd = this.lastRowEnd;
            while (this.fieldSeparatorAndNewlineMatcher.find()) {
                boolean isEnd;
                int matchStart = this.fieldSeparatorAndNewlineMatcher.start();
                int matchEnd = this.fieldSeparatorAndNewlineMatcher.end();
                boolean bl = isEnd = this.fieldSeparatorAndNewlineMatcher.start("endOfData") >= 0;
                if (this.fieldSeparatorAndNewlineMatcher.start("lineTerminator") >= 0 || isEnd) {
                    if (CustomPatternCsv.isPrecededByEffectiveQuote(this.charSequence, matchStart, this.currentFieldContentStart, quoteChar, escapeChar)) {
                        if (this.isInQuotedField.booleanValue()) {
                            this.isInQuotedField = false;
                            result = true;
                        } else {
                            ++this.quoteErrorCount;
                            result = true;
                        }
                    }
                    if (this.isInQuotedField.booleanValue()) {
                        if (!isEnd) continue;
                        ++this.quoteErrorCount;
                        result = true;
                    }
                    if (this.currentLineCount > CustomPatternCsv.this.multilineFieldMaxLines) {
                        ++this.quoteErrorCount;
                        result = true;
                    }
                    result = true;
                } else if (this.fieldSeparatorAndNewlineMatcher.start("fieldSeparator") >= 0) {
                    if (CustomPatternCsv.isPrecededByEffectiveQuote(this.charSequence, matchStart, this.currentFieldContentStart, quoteChar, escapeChar)) {
                        if (!this.isInQuotedField.booleanValue()) {
                            ++this.quoteErrorCount;
                        }
                        this.isInQuotedField = false;
                    }
                    if (this.isInQuotedField.booleanValue()) {
                        continue;
                    }
                } else {
                    throw new IllegalStateException("should not happen");
                }
                this.lastMatchedFields.add("[" + lastMatchEnd + ", " + matchStart + "]");
                lastMatchEnd = matchEnd;
                if (!this.isInQuotedField.booleanValue()) {
                    int c = CharSequences.charAt(this.charSequence, matchEnd);
                    this.isInQuotedField = c == quoteChar ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    this.currentFieldContentStart = matchEnd + 1;
                }
                if (!result) continue;
                this.lastRowStart = this.lastRowEnd;
                this.lastRowEnd = matchEnd;
                break;
            }
            if (result && logger.isTraceEnabled()) {
                logger.trace("[" + this.lastMatchedFields.stream().collect(Collectors.joining("||")) + "]");
            }
            return result;
        }

        public void setInQuotedField(boolean onOrOff) {
            this.isInQuotedField = onOrOff;
        }

        public boolean IsInQuotedField() {
            return this.isInQuotedField;
        }

        public void reset() {
            this.lastRowStart = 0;
            this.lastRowEnd = 0;
            this.currentFieldContentStart = 0;
            this.fieldSeparatorAndNewlineMatcher.reset();
        }

        @Override
        public int start() {
            return this.lastRowStart;
        }

        @Override
        public int end() {
            return this.lastRowEnd;
        }

        @Override
        public String group() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public int start(String name) {
            return this.fieldSeparatorAndNewlineMatcher.start(name);
        }

        @Override
        public int end(String name) {
            return this.fieldSeparatorAndNewlineMatcher.end(name);
        }
    }

    public static class MatchState {
        protected int currentFieldContentStart;
        protected boolean isInQuotedField;
        protected List<Row> rows;

        public MatchState(boolean isInQuotedField, List<Row> rows) {
            this.isInQuotedField = isInQuotedField;
            this.rows = rows;
        }

        public boolean isInQuotedField() {
            return this.isInQuotedField;
        }

        public List<Row> getRows() {
            return this.rows;
        }
    }

    public static class Row
    extends MatchRegion {
        protected List<Field> fields;
        int columnCount;

        public Row(long start, long end, List<Field> fields, int columnCount) {
            super(start, end);
            this.fields = fields;
            this.columnCount = columnCount;
        }
    }

    public static class Field
    extends MatchRegion {
        protected CharSequence prefix;
        protected CharSequence suffix;
        protected CharSequence content;

        public Field(long start, long end, CharSequence prefix, CharSequence suffix, CharSequence content) {
            super(start, end);
            this.prefix = prefix;
            this.suffix = suffix;
            this.content = content;
        }

        public CharSequence getPrefix() {
            return this.prefix;
        }

        public CharSequence getSuffix() {
            return this.suffix;
        }

        public CharSequence getContent() {
            return this.content;
        }
    }

    public static class MatchRegion {
        protected long start;
        protected long end;

        public MatchRegion(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

