/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Streams;
import com.univocity.parsers.csv.CsvParserSettings;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.aksw.commons.model.csvw.domain.api.DialectMutable;
import org.aksw.commons.model.csvw.univocity.UnivocityCsvwConf;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathStr;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;

public class JsonHadoopBridge {
    protected Path<String> basePath;
    protected JsonNode prototype;

    public JsonHadoopBridge(Path<String> basePath, JsonNode prototype) {
        this.basePath = basePath;
        this.prototype = prototype;
    }

    public <T> T read(Configuration conf, T bean) {
        T result;
        try {
            JsonNode node = this.read(conf);
            result = JsonHadoopBridge.read(node, bean);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static <T> T merge(T dst, Object src) {
        JsonNode state = JsonHadoopBridge.write(src);
        JsonHadoopBridge.read(state, dst);
        return dst;
    }

    public static <T> T read(JsonNode node, T bean) {
        Object result;
        try {
            result = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).readerForUpdating(bean).readValue(node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public JsonNode read(Configuration conf) {
        Function<Path<String>, String> getter = p -> {
            String key = String.join((CharSequence)".", p.getSegments());
            String r = conf.get(key);
            return r;
        };
        JsonNode dst = this.prototype.deepCopy();
        JsonNode result = JsonHadoopBridge.readRecursively(this.prototype, dst, this.basePath, getter);
        return result;
    }

    public static JsonNode write(Object bean) {
        JsonNode src = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).valueToTree(bean);
        return src;
    }

    public void write(Configuration conf, Object bean) {
        JsonNode src = JsonHadoopBridge.write(bean);
        this.write(conf, src);
    }

    public void write(Configuration conf, JsonNode src) {
        BiConsumer<Path<String>, String> setter = (p, v) -> {
            String key = String.join((CharSequence)".", p.getSegments());
            conf.set(key, v);
        };
        JsonHadoopBridge.writeRecursively(this.prototype, src, this.basePath, setter);
    }

    public static JsonNode readRecursively(JsonNode prototype, JsonNode dst, Path<String> path, Function<Path<String>, String> getter) {
        ObjectNode result;
        if (prototype == null) {
            Object var4_4 = null;
        }
        if (prototype.isObject()) {
            ObjectNode dstObj;
            ObjectNode protoObj = (ObjectNode)prototype;
            if (dst == null) {
                dstObj = JsonNodeFactory.instance.objectNode();
            } else if (dst.isObject()) {
                dstObj = (ObjectNode)dst;
            } else {
                throw new RuntimeException(String.format("Cannot read object %s into non object %s", protoObj, dst));
            }
            result = dstObj;
            Iterator it = protoObj.fields();
            while (it.hasNext()) {
                String val;
                Map.Entry e = (Map.Entry)it.next();
                String protoName = (String)e.getKey();
                Path childPath = path.resolve((Object)protoName);
                JsonNode protoValue = (JsonNode)e.getValue();
                if (protoValue.isTextual() || protoValue.isNull()) {
                    val = getter.apply((Path<String>)childPath);
                    if (val == null) continue;
                    dstObj.set(protoName, (JsonNode)JsonNodeFactory.instance.textNode(val));
                    continue;
                }
                if (protoValue.isObject()) {
                    JsonNode childNode = JsonHadoopBridge.readRecursively(protoValue, (JsonNode)dstObj, (Path<String>)childPath, getter);
                    if (childNode == null) continue;
                    dstObj.set(protoName, childNode);
                    continue;
                }
                if (!protoValue.isArray() || (val = getter.apply((Path<String>)childPath)) == null) continue;
                String[] strings = StringUtils.getStrings((String)val);
                ArrayNode arr = JsonNodeFactory.instance.arrayNode(strings.length);
                Arrays.stream(strings).forEach(arg_0 -> ((ArrayNode)arr).add(arg_0));
                dstObj.set(protoName, (JsonNode)arr);
            }
        } else {
            result = null;
        }
        return result;
    }

    public static void writeRecursively(JsonNode prototype, JsonNode src, Path<String> path, BiConsumer<Path<String>, String> setter) {
        if (prototype == null) {
            // empty if block
        }
        if (prototype.isObject()) {
            ObjectNode protoObj = (ObjectNode)prototype;
            ObjectNode srcObj = (ObjectNode)src;
            Iterator it = protoObj.fields();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                String protoName = (String)e.getKey();
                Path childPath = path.resolve((Object)protoName);
                JsonNode protoValue = (JsonNode)e.getValue();
                JsonNode srcValue = srcObj.get(protoName);
                if (srcValue == null || srcValue.isNull()) continue;
                if (protoValue != null && protoValue.isObject()) {
                    JsonHadoopBridge.writeRecursively(protoValue, srcValue, (Path<String>)childPath, setter);
                    continue;
                }
                if (Objects.equals(protoValue, srcValue)) continue;
                if (srcValue.isArray()) {
                    setter.accept((Path<String>)childPath, StringUtils.arrayToString((String[])((String[])Streams.stream((Iterator)((ArrayNode)srcValue).elements()).map(JsonNode::textValue).toArray(String[]::new))));
                    continue;
                }
                setter.accept((Path<String>)childPath, srcValue.textValue());
            }
        }
    }

    public static JsonHadoopBridge createFromPrototype(Object o, String prefix) {
        PathStr path = PathStr.newRelativePath((String[])prefix.split("\\."));
        JsonNode prototype = new ObjectMapper().valueToTree(o);
        return new JsonHadoopBridge((Path<String>)path, prototype);
    }

    public static void main(String[] args) throws JsonProcessingException {
        CsvParserSettings settings = new CsvParserSettings();
        UnivocityCsvwConf conf = new UnivocityCsvwConf();
        DialectMutable dialect = conf.getDialect().setEncoding(StandardCharsets.ISO_8859_1.name()).setCommentPrefix(".").setSkipBlankRows(Boolean.valueOf(false));
        System.out.println(settings);
    }
}

