/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.util;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

public class FileSplitUtils {
    public static InputStream getDecodedStreamFromSplit(FileSplit split, Configuration job) throws IOException {
        FSDataInputStream result;
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(job);
        FSDataInputStream fileIn = fs.open(file);
        long start = split.getStart();
        long end = start + split.getLength();
        CompressionCodec codec = new CompressionCodecFactory(job).getCodec(file);
        if (null != codec) {
            Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
            if (codec instanceof SplittableCompressionCodec) {
                SplittableCompressionCodec splitableCodec = (SplittableCompressionCodec)codec;
                result = splitableCodec.createInputStream((InputStream)fileIn, decompressor, start, end, SplittableCompressionCodec.READ_MODE.BYBLOCK);
            } else {
                result = codec.createInputStream((InputStream)fileIn, decompressor);
            }
        } else {
            result = fileIn;
        }
        return result;
    }

    public static Stream<InputSplit> streamFileSplits(Path path, long fileLengthTotal, long numSplits) throws IOException {
        long splitLength = (long)((double)fileLengthTotal / (double)numSplits);
        return LongStream.range(0L, numSplits).mapToObj(i -> {
            long start = i * splitLength;
            long end = Math.min((i + 1L) * splitLength, fileLengthTotal);
            long length = end - start;
            return new FileSplit(path, start, length, null);
        });
    }

    public static List<InputSplit> listFileSplits(Path path, long fileLengthTotal, long numSplits) throws IOException {
        List<InputSplit> result = FileSplitUtils.streamFileSplits(path, fileLengthTotal, numSplits).collect(Collectors.toList());
        return result;
    }

    public static <T> Stream<T> createFlow(Job job, InputFormat<?, T> inputFormat, InputSplit inputSplit) {
        RecordReader reader;
        try {
            reader = inputFormat.createRecordReader(inputSplit, (TaskAttemptContext)new TaskAttemptContextImpl(job.getConfiguration(), new TaskAttemptID()));
            reader.initialize(inputSplit, (TaskAttemptContext)new TaskAttemptContextImpl(job.getConfiguration(), new TaskAttemptID()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Stream result = (Stream)Stream.generate(() -> {
            try {
                return reader.nextKeyValue() ? reader.getCurrentValue() : null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).takeWhile(x -> x != null).onClose(() -> {
            try {
                reader.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    public static <T> Flowable<T> createFlow2(Job job, InputFormat<?, T> inputFormat, InputSplit inputSplit) {
        return Flowable.generate(() -> {
            RecordReader reader = inputFormat.createRecordReader(inputSplit, (TaskAttemptContext)new TaskAttemptContextImpl(job.getConfiguration(), new TaskAttemptID()));
            reader.initialize(inputSplit, (TaskAttemptContext)new TaskAttemptContextImpl(job.getConfiguration(), new TaskAttemptID()));
            return reader;
        }, (reader, emitter) -> {
            try {
                if (reader.nextKeyValue()) {
                    Object record = reader.getCurrentValue();
                    emitter.onNext(record);
                } else {
                    emitter.onComplete();
                }
            }
            catch (Exception e) {
                emitter.onError((Throwable)e);
            }
        }, AutoCloseable::close);
    }

    public static List<Object[]> createTestParameters(Map<String, Range<Integer>> fileToNumSplits) {
        List<Object[]> result = fileToNumSplits.entrySet().stream().flatMap(e -> ContiguousSet.create((Range)((Range)e.getValue()), (DiscreteDomain)DiscreteDomain.integers()).stream().map(numSplits -> new Object[]{e.getKey(), numSplits})).collect(Collectors.toList());
        return result;
    }
}

