/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.output.jena.base;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.riot.system.StreamRDF;

public class RecordWriterStreamRDF<T>
extends RecordWriter<Long, T> {
    protected StreamRDF streamRdf;
    protected BiConsumer<StreamRDF, T> sendRecordToStreamRdf;
    protected AutoCloseable closeAction;

    public RecordWriterStreamRDF(StreamRDF streamRdf, BiConsumer<StreamRDF, T> sendRecordToStreamRdf, AutoCloseable closeAction) {
        this.streamRdf = streamRdf;
        this.sendRecordToStreamRdf = sendRecordToStreamRdf;
        this.closeAction = closeAction;
    }

    public void write(Long aLong, T record) throws IOException, InterruptedException {
        this.sendRecordToStreamRdf.accept(this.streamRdf, (StreamRDF)record);
    }

    public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        try {
            this.streamRdf.finish();
            this.closeAction.close();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

