/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.output.jena.base;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sansa_stack.hadoop.output.jena.base.FragmentOutputSpec;
import net.sansa_stack.hadoop.output.jena.base.OutputUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class OutputFormatBase<T>
extends FileOutputFormat<Long, T> {
    public RecordWriter<Long, T> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        Configuration conf = job.getConfiguration();
        int splitCount = OutputUtils.getSplitCount(conf);
        TaskAttemptID taskAttemptId = job.getTaskAttemptID();
        TaskID taskId = taskAttemptId.getTaskID();
        int splitId = taskId.getId();
        boolean isCompressed = OutputFormatBase.getCompressOutput((JobContext)job);
        CompressionCodec codec = null;
        String extension = "";
        if (isCompressed) {
            Class codecClass = OutputFormatBase.getOutputCompressorClass((JobContext)job, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            extension = codec.getDefaultExtension();
        }
        Path file = this.getDefaultWorkFile(job, extension);
        FileSystem fs = file.getFileSystem(conf);
        boolean overwrite = false;
        Object out = fs.create(file, overwrite);
        if (isCompressed) {
            out = new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)out));
        }
        FragmentOutputSpec fragmentOutputSpec = FragmentOutputSpec.create(splitCount, splitId);
        return this.getRecordWriter(conf, (OutputStream)out, fragmentOutputSpec);
    }

    protected abstract RecordWriter<Long, T> getRecordWriter(Configuration var1, OutputStream var2, FragmentOutputSpec var3);
}

