/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.jena.locator;

import java.io.InputStream;
import java.util.Arrays;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.stream.LocatorURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorHdfs
extends LocatorURL {
    private static Logger log = LoggerFactory.getLogger(LocatorHdfs.class);
    public static final String[] SCHEME_NAMES = new String[]{"hdfs"};
    protected FileSystem fileSystem;
    protected String[] xschemeNames;

    public LocatorHdfs(FileSystem fileSystem) {
        this(fileSystem, SCHEME_NAMES);
    }

    public LocatorHdfs(FileSystem fileSystem, String[] schemeNames) {
        super(schemeNames);
        this.fileSystem = fileSystem;
        this.xschemeNames = schemeNames;
    }

    protected Logger log() {
        return log;
    }

    public TypedInputStream performOpen(String uri) {
        TypedInputStream result = null;
        if (Arrays.stream(this.xschemeNames).anyMatch(schemaName -> uri.startsWith((String)schemaName))) {
            FSDataInputStream in;
            ContentType contentType = RDFLanguages.guessContentType((String)uri);
            Path path = new Path(uri);
            try {
                in = this.fileSystem.open(path);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            result = new TypedInputStream((InputStream)in, contentType);
        }
        return result;
    }

    public String getName() {
        return "LocatorHdfs";
    }

    public int hashCode() {
        return 83;
    }
}

