/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.format.jena.trig;

import io.reactivex.rxjava3.core.Flowable;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import net.sansa_stack.hadoop.core.Accumulating;
import net.sansa_stack.hadoop.core.pattern.CustomPattern;
import net.sansa_stack.hadoop.core.pattern.CustomPatternJava;
import net.sansa_stack.hadoop.format.jena.base.RecordReaderGenericRdfAccumulatingBase;
import net.sansa_stack.hadoop.format.jena.base.RecordReaderRdfConf;
import org.aksw.jenax.arq.dataset.api.DatasetOneNg;
import org.aksw.jenax.arq.dataset.impl.DatasetOneNgImpl;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrRx;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.riot.Lang;
import org.apache.jena.sparql.core.Quad;

public class RecordReaderRdfTrigDataset
extends RecordReaderGenericRdfAccumulatingBase<Quad, Node, DatasetOneNg, DatasetOneNg> {
    public static final String RECORD_MINLENGTH_KEY = "mapreduce.input.trig.dataset.record.minlength";
    public static final String RECORD_MAXLENGTH_KEY = "mapreduce.input.trig.dataset.record.maxlength";
    public static final String RECORD_PROBECOUNT_KEY = "mapreduce.input.trig.dataset.record.probecount";
    public static final String ELEMENT_PROBECOUNT_KEY = "mapreduce.input.trig.dataset.element.probecount";
    public static final String PREFIXES_MAXLENGTH_KEY = "mapreduce.input.trig.dataset.prefixes.maxlength";
    protected static final CustomPattern trigFwdPatternGraphFollowedByCurlyBrace = CustomPatternJava.compile("@?base|@?prefix|(graph\\s*)?(<[^>]*>|_?:[^-\\s]+)\\s*\\{", 10);
    protected static final CustomPattern trigFwdPatternNew;
    protected static final CustomPattern trigFwdPattern;

    public RecordReaderRdfTrigDataset() {
        super(new RecordReaderRdfConf(RECORD_MINLENGTH_KEY, RECORD_MAXLENGTH_KEY, RECORD_PROBECOUNT_KEY, trigFwdPattern, PREFIXES_MAXLENGTH_KEY, Lang.TRIG), new AccumulatingDataset());
    }

    @Override
    protected Stream<Quad> parse(InputStream in, boolean isProbe) {
        Stream result = this.setupParser(in, isProbe).streamQuads();
        return result;
    }

    protected Flowable<Quad> parse(Callable<InputStream> inputStreamSupplier) {
        Flowable result = RDFDataMgrRx.createFlowableQuads(inputStreamSupplier, (Lang)this.lang, (String)this.baseIri);
        return result;
    }

    static {
        trigFwdPattern = trigFwdPatternNew = CustomPatternJava.compile("@?base|@?prefix|(graph\\s*)?(<[^>]*>|_?:[^-\\s]+)", 10);
    }

    public static class AccumulatingDataset
    implements Accumulating<Quad, Node, DatasetOneNg, DatasetOneNg> {
        @Override
        public Node classify(Quad item) {
            return item.getGraph();
        }

        @Override
        public DatasetOneNg createAccumulator(Node groupKey) {
            String graphName = groupKey == null ? Quad.defaultGraphNodeGenerated.getURI() : groupKey.getURI();
            DatasetOneNg result = DatasetOneNgImpl.create((String)graphName);
            result.begin(ReadWrite.WRITE);
            return result;
        }

        @Override
        public void accumulate(DatasetOneNg accumulator, Quad item) {
            accumulator.asDatasetGraph().add(item);
        }

        @Override
        public DatasetOneNg accumulatedValue(DatasetOneNg accumulator) {
            accumulator.commit();
            return accumulator;
        }
    }
}

