/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.format.commons_csv.csv;

import io.reactivex.rxjava3.core.Flowable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import org.aksw.commons.lambda.throwing.ThrowingBiConsumer;
import org.aksw.commons.lambda.throwing.ThrowingFunction;
import org.aksw.commons.lambda.throwing.ThrowingSupplier;
import org.aksw.commons.rx.util.FlowableEx;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class CsvUtils {
    public static Flowable<CSVRecord> readCsvRecords(String path, FileSystem fileSystem, CSVFormat csvFormat) {
        return CsvUtils.readCsvRecords(new Path(path), fileSystem, csvFormat);
    }

    public static Flowable<CSVRecord> readCsvRecords(Path path, FileSystem fileSystem, CSVFormat csvFormat) {
        return CsvUtils.readCsvRecords(() -> fileSystem.open(path), csvFormat);
    }

    public static Flowable<List<String>> readCsvRows(Path path, FileSystem fileSystem, CSVFormat csvFormat) {
        return CsvUtils.readCsvRecords(path, fileSystem, csvFormat).map(CSVRecord::toList);
    }

    public static Flowable<List<String>> readCsvRows(String path, FileSystem fileSystem, CSVFormat csvFormat) {
        return CsvUtils.readCsvRecords(path, fileSystem, csvFormat).map(CSVRecord::toList);
    }

    public static Flowable<CSVRecord> readCsvRecords(Callable<? extends InputStream> inSupp, CSVFormat csvFormat) {
        return FlowableEx.fromIterableResource((ThrowingSupplier & Serializable)() -> new InputStreamReader((InputStream)inSupp.call()), (ThrowingFunction & Serializable)reader -> new CSVParser((Reader)reader, csvFormat), (ThrowingFunction & Serializable)csvParser -> csvParser.iterator(), (ThrowingBiConsumer & Serializable)(in, csvParser) -> {
            if (csvParser != null) {
                csvParser.close();
            } else if (in != null) {
                in.close();
            }
        });
    }
}

