/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.core.pattern;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import net.sansa_stack.hadoop.core.pattern.CharSequenceReverse;
import net.sansa_stack.hadoop.core.pattern.CustomMatcher;
import net.sansa_stack.hadoop.core.pattern.CustomMatcherBase;
import net.sansa_stack.hadoop.core.pattern.CustomPattern;

public class CustomPatternTrigGraph
implements CustomPattern {
    public static Pattern TRIG_GRAPH_REVERSE_PATTERN = Pattern.compile((String)"\\s*((>[^<]<\\s*)|[^\\s]+:\\w*)(hparg)?", (int)1);

    @Override
    public CustomMatcher matcher(CharSequence charSequence) {
        return new CustomMatcherTrigGraph(charSequence);
    }

    public static class CustomMatcherTrigGraph
    extends CustomMatcherBase {
        protected int lastMatchPosStart = -1;
        protected int lastMatchPosEnd = -1;

        public CustomMatcherTrigGraph(CharSequence charSequence) {
            super(charSequence);
        }

        @Override
        public boolean find() {
            boolean result = false;
            if (this.pos >= this.regionStart) {
                while (this.pos < this.regionEnd) {
                    CharSequenceReverse reverse;
                    Matcher m;
                    char c = this.charSequence.charAt(this.pos);
                    if (c == '{' && (m = TRIG_GRAPH_REVERSE_PATTERN.matcher((CharSequence)(reverse = new CharSequenceReverse(this.charSequence, this.pos)))).find()) {
                        result = true;
                        int end = m.end();
                        this.lastMatchPosStart = this.pos - end;
                        this.lastMatchPosEnd = this.pos++;
                        break;
                    }
                    ++this.pos;
                }
            }
            return result;
        }

        @Override
        public int start() {
            return this.lastMatchPosStart;
        }

        @Override
        public int end() {
            return this.lastMatchPosEnd;
        }

        @Override
        public String group() {
            if (this.lastMatchPosStart < 0) {
                throw new IllegalStateException();
            }
            String result = this.charSequence.subSequence(this.lastMatchPosStart, this.lastMatchPosEnd).toString();
            return result;
        }
    }
}

