/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.core.pattern;

import java.util.Optional;
import java.util.regex.Pattern;
import net.sansa_stack.hadoop.core.pattern.CustomPatternCsvOld;
import org.aksw.commons.model.csvw.domain.api.Dialect;
import org.aksw.commons.model.csvw.domain.impl.CsvwLib;

public class CustomPatternCsvFromCsvwOld {
    public static CustomPatternCsvOld.Config adapt(Dialect dialect, int maxColumnLength) {
        char quoteChar = CsvwLib.expectAtMostOneChar((String)"quoteChar", (String)dialect.getQuoteChar(), (Character)Character.valueOf('\"')).charValue();
        char escapeChar = CsvwLib.expectAtMostOneChar((String)"quoteEscapeChar", (String)dialect.getQuoteEscapeChar(), (Character)Character.valueOf('\"')).charValue();
        String delimiterPattern = Optional.ofNullable(dialect.getDelimiter()).orElse(Pattern.quote(","));
        String lineTerminatorPattern = Optional.ofNullable(dialect.getLineTerminators()).orElse("\r?\n\r?");
        return new CustomPatternCsvOld.Config(quoteChar, escapeChar, delimiterPattern, lineTerminatorPattern, maxColumnLength, 20);
    }
}

