/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.core.pattern;

import com.google.common.base.Preconditions;
import java.util.stream.IntStream;
import net.sansa_stack.hadoop.core.pattern.CharSequences;

public class CharSequenceReverse
implements CharSequence {
    protected CharSequence base;
    protected int reverseStart;
    protected int reverseEnd;

    public CharSequenceReverse(CharSequence base, int reverseStart) {
        this(base, reverseStart, -1);
    }

    public CharSequenceReverse(CharSequence base, int reverseStart, int reverseEnd) {
        this.base = base;
        this.reverseStart = reverseStart;
        this.reverseEnd = reverseEnd;
        Preconditions.checkArgument((reverseEnd >= -1 ? 1 : 0) != 0, (Object)String.format("reverseEnd (%d) must be >= -1", reverseEnd));
        Preconditions.checkArgument((reverseStart >= reverseEnd ? 1 : 0) != 0, (Object)String.format("reverseStart (%d) must be >= reverseEnd (%d)", reverseStart, reverseEnd));
    }

    @Override
    public int length() {
        return this.reverseStart - this.reverseEnd;
    }

    @Override
    public char charAt(int index) {
        return this.base.charAt(this.reverseStart - index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (Object)String.format("start (%d) must be <= end (%d)", start, end));
        int effStart = this.reverseStart - start;
        int effEnd = this.reverseStart - end;
        Preconditions.checkArgument((effStart >= 0 && effEnd >= -1 ? 1 : 0) != 0, (Object)String.format("Effective start (%d) and effective end (%d) must be >= 0", effStart, effEnd));
        return new CharSequenceReverse(this.base, effStart, effEnd);
    }

    @Override
    public String toString() {
        String result = CharSequences.toString(this);
        return result;
    }

    @Override
    public IntStream chars() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public IntStream codePoints() {
        throw new UnsupportedOperationException("not implemented");
    }
}

