/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.core;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Objects;
import net.sansa_stack.hadoop.core.RecordReaderGenericBase;
import net.sansa_stack.hadoop.core.Stats2;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.rdf.model.Resource;

public class RecordReaderGenericBaseStatsWrapper
extends RecordReader<LongWritable, Resource> {
    protected Stats2 stats = null;
    protected RecordReaderGenericBase<?, ?, ?, ?> decoratee;

    public RecordReaderGenericBaseStatsWrapper(RecordReaderGenericBase<?, ?, ?, ?> decoratee) {
        Objects.requireNonNull(decoratee);
        this.decoratee = decoratee;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.decoratee.initialize(split, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextKeyValue() throws IOException, InterruptedException {
        boolean result;
        block5: {
            result = false;
            if (this.stats != null) break block5;
            Throwable throwable = null;
            StopWatch sw = StopWatch.createStarted();
            try {
                boolean wasInterrupted;
                while (!(wasInterrupted = Thread.interrupted()) && this.decoratee.nextKeyValue()) {
                    this.decoratee.nextKeyValue();
                }
                this.stats = this.decoratee.getStats();
                this.stats.setTotalTime((double)sw.getNanoTime() * 1.0E-9);
            }
            catch (Throwable t) {
                try {
                    throwable = t;
                    this.stats = this.decoratee.getStats();
                    this.stats.setTotalTime((double)sw.getNanoTime() * 1.0E-9);
                }
                catch (Throwable throwable2) {
                    this.stats = this.decoratee.getStats();
                    this.stats.setTotalTime((double)sw.getNanoTime() * 1.0E-9);
                    this.stats.setErrorMessage(throwable == null ? null : Throwables.getStackTraceAsString((Throwable)throwable));
                    throw throwable2;
                }
                this.stats.setErrorMessage(throwable == null ? null : Throwables.getStackTraceAsString((Throwable)throwable));
            }
            this.stats.setErrorMessage(throwable == null ? null : Throwables.getStackTraceAsString((Throwable)throwable));
            result = true;
        }
        return result;
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.stats == null ? null : new LongWritable(0L);
    }

    public Resource getCurrentValue() throws IOException, InterruptedException {
        return this.stats.asResource();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.decoratee.getProgress();
    }

    public void close() throws IOException {
        this.decoratee.close();
    }
}

