/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.hadoop.core;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import net.sansa_stack.hadoop.core.RecordReaderGenericBase;
import net.sansa_stack.hadoop.core.RecordReaderGenericBaseStatsWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.rdf.model.Resource;

public class InputFormatStats
extends InputFormat<LongWritable, Resource> {
    protected InputFormat<?, ?> decoratee;

    public InputFormatStats() {
        this(null);
    }

    public InputFormatStats(InputFormat<?, ?> decoratee) {
        this.decoratee = decoratee;
    }

    public void ensureInit(Configuration hc) {
        if (this.decoratee == null) {
            String className = hc.get("sansa.delegate");
            Preconditions.checkNotNull((Object)className, (Object)("Delegate class not set - must be a fully qualified class name that is a subclass of " + RecordReaderGenericBase.class.getName()));
            try {
                Class<?> clz = Class.forName(className);
                this.decoratee = (InputFormat)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public RecordReader<LongWritable, Resource> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.ensureInit(context.getConfiguration());
        RecordReader reader = this.decoratee.createRecordReader(split, context);
        RecordReaderGenericBase tmp = (RecordReaderGenericBase)reader;
        return new RecordReaderGenericBaseStatsWrapper(tmp);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        this.ensureInit(context.getConfiguration());
        List result = this.decoratee.getSplits(context);
        return result;
    }
}

