/*
 *  Word.java
 *
 *  Copyright (c) 1995-2010, The University of Sheffield. See the file
 *  COPYRIGHT.txt in the software or at http://gate.ac.uk/gate/COPYRIGHT.txt
 *
 *  This file is part of GATE (see http://gate.ac.uk/), and is free
 *  software, licenced under the GNU Library General Public License,
 *  Version 2, June 1991 (in the distribution as file licence.html,
 *  and also available at http://gate.ac.uk/gate/licence.html).
 *
 *  Marin Dimitrov, 16/May/2002
 *
 *  $Id: Word.java 12006 2009-12-01 17:24:28Z thomas_heitz $
 */

package gate.wordnet;

import java.util.List;


/** Represents WordNet word.
 */
public interface Word {

  /** returns the senses of this word */
  public List getWordSenses() throws WordNetException;

  /** returns the lemma of this word */
  public String getLemma();

  /** returns the number of senses of this word (not necessarily loading them from storage) */
  public int getSenseCount();

}

