package gate.util;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.Gate;

import java.util.ArrayList;
import java.net.URL;
import java.net.URI;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestClassificationMeasures extends TestCase{

  /** Test suite routine for the test runner */
  public static Test suite() {
    return new TestSuite(TestClassificationMeasures.class);
  } // suite

  
  @Override
  protected void setUp() throws Exception {
    // TODO Auto-generated method stub
    super.setUp();
  }

  @Override
  protected void tearDown() throws Exception {
    // TODO Auto-generated method stub
    super.tearDown();
  }
 
  public void test(){
    String type = "sent";
    String feature = "Op";
        
    Document doc1 = null;
    Document doc2 = null;
    Document doc3 = null;
    Document doc4 = null;
        
    try {
      Gate.init();
          
      URI uri1 = new URI("http://gate.ac.uk/tests/iaa/beijing-opera.xml");
      URI uri2 = new URI("http://gate.ac.uk/tests/iaa/beijing-opera.xml");
      URI uri3 = new URI("http://gate.ac.uk/tests/iaa/in-outlook-09-aug-2001.xml");
      URI uri4 = new URI("http://gate.ac.uk/tests/iaa/in-outlook-09-aug-2001.xml");
      
      doc1 = Factory.newDocument(uri1.toURL());
      doc2 = Factory.newDocument(uri2.toURL());
      doc3 = Factory.newDocument(uri3.toURL());
      doc4 = Factory.newDocument(uri4.toURL());
        
    } catch (Exception e) {
      e.printStackTrace();
    }
    
    if(doc1!=null && doc2!=null && doc3!=null && doc4!=null){
      AnnotationSet as1 = doc1.getAnnotations("ann1");
      AnnotationSet as2 = doc2.getAnnotations("ann2");

      ClassificationMeasures myClassificationMeasures1 =
        new ClassificationMeasures();
      myClassificationMeasures1.calculateConfusionMatrix(
        as1, as2, type, feature, true);
      assertEquals(myClassificationMeasures1.getObservedAgreement(), 0.7777778f);
      assertEquals(myClassificationMeasures1.getKappaCohen(), 0.6086957f);
      assertEquals(myClassificationMeasures1.getKappaPi(), 0.59550565f);
      
      AnnotationSet as3 = doc3.getAnnotations("ann1");
      AnnotationSet as4 = doc4.getAnnotations("ann2");
       
      ClassificationMeasures myClassificationMeasures2 =
        new ClassificationMeasures();
      myClassificationMeasures2.calculateConfusionMatrix(
        as3, as4, type, feature, true);
      assertEquals(myClassificationMeasures2.getObservedAgreement(), 0.96875f);
      assertEquals(myClassificationMeasures2.getKappaCohen(), 0.3263158f);
      assertEquals(myClassificationMeasures2.getKappaPi(), 0.3227513f);
       
      ArrayList<ClassificationMeasures> tablesList = new ArrayList<ClassificationMeasures>();
      tablesList.add(myClassificationMeasures1);
      tablesList.add(myClassificationMeasures2);
      ClassificationMeasures myNewClassificationMeasures =
        new ClassificationMeasures(tablesList);
      assertEquals(myNewClassificationMeasures.getObservedAgreement(), 0.94520545f);
      assertEquals(myNewClassificationMeasures.getKappaCohen(), 0.7784521f);
      assertEquals(myNewClassificationMeasures.getKappaPi(), 0.7778622f);
       
    } else {
      System.out.println("Failed to create docs from URLs.");
    }
  }
}
