/*
 * MinCardinalityRestriction.java
 *
 * $Id: MinCardinalityRestriction.java 11598 2009-10-13 13:44:17Z johann_p $
 * 
 */
package gate.creole.ontology;

/**
 * A MinCardinalityRestriction.
 *
 * @author Niraj Aswani
 *
 */
public interface MinCardinalityRestriction extends Restriction {

    /**
     * This method returns the mimimum cardinality value allowed for this value.
     * @return
     */
    public String getValue();
    
    /**
     * This method returns the datatype associated to the restriction.
     * @return
    */
    public DataType getDataType();
    
  /**
   * Sets the cardinality value.
   * @param value
   * @param dataType
   * @throws InvalidValueException
   */
  public void setValue(String value, DataType dataType) throws InvalidValueException;
    
}
