/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.classfmt;

import gate.util.compilers.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public abstract class ClassFileStruct {
    byte[] reference;
    int[] constantPoolOffsets;
    int structOffset;

    public static String printTypeModifiers(int modifiers) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter print = new PrintWriter(out);
        if ((modifiers & 1) != 0) {
            print.print("public ");
        }
        if ((modifiers & 2) != 0) {
            print.print("private ");
        }
        if ((modifiers & 0x10) != 0) {
            print.print("final ");
        }
        if ((modifiers & 0x20) != 0) {
            print.print("super ");
        }
        if ((modifiers & 0x200) != 0) {
            print.print("interface ");
        }
        if ((modifiers & 0x400) != 0) {
            print.print("abstract ");
        }
        print.flush();
        return out.toString();
    }

    public static void verifyMethodNameAndSignature(char[] name, char[] signature) throws ClassFormatException {
        if (name.length == 0) {
            throw new ClassFormatException(27);
        }
        if (name[0] == '<') {
            if (new String(name).equals("<clinit>") || new String(name).equals("<init>")) {
                int signatureLength = signature.length;
                if (signatureLength <= 2 || signature[0] != '(' || signature[signatureLength - 2] != ')' || signature[signatureLength - 1] != 'V') {
                    throw new ClassFormatException(28);
                }
            } else {
                throw new ClassFormatException(27);
            }
        }
    }

    public ClassFileStruct(byte[] classFileBytes, int[] offsets, int offset) {
        this.reference = classFileBytes;
        this.constantPoolOffsets = offsets;
        this.structOffset = offset;
    }

    public double doubleAt(int relativeOffset) {
        return Double.longBitsToDouble(this.i8At(relativeOffset));
    }

    public float floatAt(int relativeOffset) {
        return Float.intBitsToFloat(this.i4At(relativeOffset));
    }

    public int i1At(int relativeOffset) {
        return this.reference[relativeOffset + this.structOffset];
    }

    public int i2At(int relativeOffset) {
        int position = relativeOffset + this.structOffset;
        return this.reference[position++] << 8 | this.reference[position] & 0xFF;
    }

    public int i4At(int relativeOffset) {
        int position = relativeOffset + this.structOffset;
        return (this.reference[position++] & 0xFF) << 24 | (this.reference[position++] & 0xFF) << 16 | ((this.reference[position++] & 0xFF) << 8) + (this.reference[position] & 0xFF);
    }

    public long i8At(int relativeOffset) {
        int position = relativeOffset + this.structOffset;
        return (long)(this.reference[position++] & 0xFF) << 56 | (long)(this.reference[position++] & 0xFF) << 48 | (long)(this.reference[position++] & 0xFF) << 40 | (long)(this.reference[position++] & 0xFF) << 32 | (long)(this.reference[position++] & 0xFF) << 24 | (long)(this.reference[position++] & 0xFF) << 16 | (long)(this.reference[position++] & 0xFF) << 8 | (long)(this.reference[position++] & 0xFF);
    }

    protected void reset() {
        this.reference = null;
        this.constantPoolOffsets = null;
    }

    public int u1At(int relativeOffset) {
        return this.reference[relativeOffset + this.structOffset] & 0xFF;
    }

    public int u2At(int relativeOffset) {
        int position = relativeOffset + this.structOffset;
        return (this.reference[position++] & 0xFF) << 8 | this.reference[position] & 0xFF;
    }

    public long u4At(int relativeOffset) {
        int position = relativeOffset + this.structOffset;
        return ((long)this.reference[position++] & 0xFFL) << 24 | (long)((this.reference[position++] & 0xFF) << 16) | (long)((this.reference[position++] & 0xFF) << 8) | (long)(this.reference[position] & 0xFF);
    }

    public char[] utf8At(int relativeOffset, int bytesAvailable) {
        int length = bytesAvailable;
        char[] outputBuf = new char[bytesAvailable];
        int outputPos = 0;
        int readOffset = this.structOffset + relativeOffset;
        while (length != 0) {
            int x = this.reference[readOffset++] & 0xFF;
            --length;
            if ((0x80 & x) != 0) {
                if ((x & 0x20) != 0) {
                    length -= 2;
                    x = (x & 0xF) << 12 | (this.reference[readOffset++] & 0x3F) << 6 | this.reference[readOffset++] & 0x3F;
                } else {
                    --length;
                    x = (x & 0x1F) << 6 | this.reference[readOffset++] & 0x3F;
                }
            }
            outputBuf[outputPos++] = (char)x;
        }
        if (outputPos != bytesAvailable) {
            char[] cArray = outputBuf;
            outputBuf = new char[outputPos];
            System.arraycopy(cArray, 0, outputBuf, 0, outputPos);
        }
        return outputBuf;
    }

    public char[] utf8At(int relativeOffset, int bytesAvailable, boolean testValidity) throws ClassFormatException {
        int length = bytesAvailable;
        char[] outputBuf = new char[bytesAvailable];
        int outputPos = 0;
        int readOffset = this.structOffset + relativeOffset;
        while (length != 0) {
            int x = this.reference[readOffset++] & 0xFF;
            --length;
            if ((0x80 & x) != 0) {
                if (testValidity) {
                    if ((0x40 & x) == 0) {
                        throw new ClassFormatException(19);
                    }
                    if (length < 1) {
                        throw new ClassFormatException(19);
                    }
                }
                int y = this.reference[readOffset++] & 0xFF;
                --length;
                if (testValidity && (y & 0xC0) != 128) {
                    throw new ClassFormatException(19);
                }
                if ((x & 0x20) != 0) {
                    if (testValidity && length < 1) {
                        throw new ClassFormatException(19);
                    }
                    int z = this.reference[readOffset++] & 0xFF;
                    --length;
                    if (testValidity && (z & 0xC0) != 128) {
                        throw new ClassFormatException(19);
                    }
                    x = ((x & 0x1F) << 12) + ((y & 0x3F) << 6) + (z & 0x3F);
                    if (testValidity && x < 2048) {
                        throw new ClassFormatException(19);
                    }
                } else {
                    x = ((x & 0x1F) << 6) + (y & 0x3F);
                    if (testValidity && x != 0 && x < 128) {
                        throw new ClassFormatException(19);
                    }
                }
            } else if (testValidity && x == 0) {
                throw new ClassFormatException(19);
            }
            outputBuf[outputPos++] = (char)x;
        }
        if (outputPos != bytesAvailable) {
            char[] cArray = outputBuf;
            outputBuf = new char[outputPos];
            System.arraycopy(cArray, 0, outputBuf, 0, outputPos);
        }
        return outputBuf;
    }
}

