/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.ast;

import gate.util.compilers.eclipse.jdt.internal.compiler.ASTVisitor;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.ASTNode;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Expression;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Statement;
import gate.util.compilers.eclipse.jdt.internal.compiler.codegen.CodeStream;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.FlowContext;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.FlowInfo;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.BlockScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ThrowStatement
extends Statement {
    public Expression exception;
    public TypeBinding exceptionType;

    public ThrowStatement(Expression exception, int startPosition) {
        this.exception = exception;
        this.sourceStart = startPosition;
        this.sourceEnd = exception.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.exception.analyseCode(currentScope, flowContext, flowInfo);
        flowContext.checkExceptionHandlers(this.exceptionType, (ASTNode)this, flowInfo, currentScope);
        return FlowInfo.DEAD_END;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        this.exception.generateCode(currentScope, codeStream, true);
        codeStream.athrow();
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ThrowStatement.printIndent(indent, output).append("throw ");
        this.exception.printExpression(0, output);
        return output.append(';');
    }

    public void resolve(BlockScope scope) {
        this.exceptionType = this.exception.resolveTypeExpecting(scope, scope.getJavaLangThrowable());
        if (this.exceptionType == TypeBinding.NULL && scope.compilerOptions().complianceLevel <= 0x2F0000L) {
            scope.problemReporter().cannotThrowNull(this);
        }
        this.exception.computeConversion(scope, this.exceptionType, this.exceptionType);
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.exception.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

