/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.ast;

import gate.util.compilers.eclipse.jdt.internal.compiler.ASTVisitor;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Expression;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Statement;
import gate.util.compilers.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import gate.util.compilers.eclipse.jdt.internal.compiler.codegen.CodeStream;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.FlowContext;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.FlowInfo;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import gate.util.compilers.eclipse.jdt.internal.compiler.impl.Constant;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.BlockScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class DoStatement
extends Statement {
    public Expression condition;
    public Statement action;
    private BranchLabel breakLabel;
    private BranchLabel continueLabel;
    int mergedInitStateIndex = -1;

    public DoStatement(Expression condition, Statement action, int s, int e) {
        this.sourceStart = s;
        this.sourceEnd = e;
        this.condition = condition;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.breakLabel = new BranchLabel();
        this.continueLabel = new BranchLabel();
        LoopingFlowContext loopingContext = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, currentScope);
        Constant cst = this.condition.constant;
        boolean isConditionTrue = cst != Constant.NotAConstant && cst.booleanValue();
        cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != Constant.NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != Constant.NotAConstant && !cst.booleanValue();
        int previousMode = flowInfo.reachMode();
        UnconditionalFlowInfo actionInfo = flowInfo.nullInfoLessUnconditionalCopy();
        if (this.action != null && !this.action.isEmptyBlock()) {
            actionInfo = this.action.analyseCode(currentScope, loopingContext, actionInfo).unconditionalInits();
            if ((actionInfo.tagBits & loopingContext.initsOnContinue.tagBits & 1) != 0) {
                this.continueLabel = null;
            }
        }
        actionInfo.setReachMode(previousMode);
        LoopingFlowContext condLoopContext = new LoopingFlowContext(flowContext, flowInfo, this, null, null, currentScope);
        FlowInfo condInfo = this.condition.analyseCode(currentScope, condLoopContext, (this.action == null ? actionInfo : actionInfo.mergedWith(loopingContext.initsOnContinue)).copy());
        if (!isConditionOptimizedFalse && this.continueLabel != null) {
            loopingContext.complainOnDeferredFinalChecks(currentScope, condInfo);
            condLoopContext.complainOnDeferredFinalChecks(currentScope, condInfo);
            UnconditionalFlowInfo checkFlowInfo = actionInfo.addPotentialNullInfoFrom(condInfo.initsWhenTrue().unconditionalInits());
            loopingContext.complainOnDeferredNullChecks(currentScope, checkFlowInfo);
            condLoopContext.complainOnDeferredNullChecks(currentScope, checkFlowInfo);
        }
        UnconditionalFlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches((loopingContext.initsOnBreak.tagBits & 1) != 0 ? loopingContext.initsOnBreak : flowInfo.unconditionalCopy().addInitializationsFrom(loopingContext.initsOnBreak), isConditionOptimizedTrue, (condInfo.tagBits & 1) == 0 ? flowInfo.addInitializationsFrom(condInfo.initsWhenFalse()) : condInfo, false, !isConditionTrue);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        Constant cst;
        boolean isConditionOptimizedFalse;
        boolean hasContinueLabel;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        BranchLabel actionLabel = new BranchLabel(codeStream);
        if (this.action != null) {
            actionLabel.tagBits |= 2;
        }
        actionLabel.place();
        this.breakLabel.initialize(codeStream);
        boolean bl = hasContinueLabel = this.continueLabel != null;
        if (hasContinueLabel) {
            this.continueLabel.initialize(codeStream);
        }
        if (this.action != null) {
            this.action.generateCode(currentScope, codeStream);
        }
        if (hasContinueLabel) {
            this.continueLabel.place();
        }
        boolean bl2 = isConditionOptimizedFalse = (cst = this.condition.optimizedBooleanConstant()) != Constant.NotAConstant && !cst.booleanValue();
        if (isConditionOptimizedFalse) {
            this.condition.generateCode(currentScope, codeStream, false);
        } else if (hasContinueLabel) {
            this.condition.generateOptimizedBoolean(currentScope, codeStream, actionLabel, null, true);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        if (this.breakLabel.forwardReferenceCount > 0) {
            this.breakLabel.place();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        DoStatement.printIndent(indent, output).append("do");
        if (this.action == null) {
            output.append(" ;\n");
        } else {
            output.append('\n');
            this.action.printStatement(indent + 1, output).append('\n');
        }
        output.append("while (");
        return this.condition.printExpression(0, output).append(");");
    }

    public void resolve(BlockScope scope) {
        TypeBinding type = this.condition.resolveTypeExpecting(scope, TypeBinding.BOOLEAN);
        this.condition.computeConversion(scope, type, type);
        if (this.action != null) {
            this.action.resolve(scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.action != null) {
                this.action.traverse(visitor, scope);
            }
            this.condition.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

