/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sequencing;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ConcurrencyException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.helper.ConcurrencyManager;
import oracle.toplink.essentials.internal.sequencing.DatabaseSessionConnectionHandler;
import oracle.toplink.essentials.internal.sequencing.PreallocationHandler;
import oracle.toplink.essentials.internal.sequencing.Sequencing;
import oracle.toplink.essentials.internal.sequencing.SequencingCallback;
import oracle.toplink.essentials.internal.sequencing.SequencingConnectionHandler;
import oracle.toplink.essentials.internal.sequencing.SequencingHome;
import oracle.toplink.essentials.internal.sequencing.SequencingServer;
import oracle.toplink.essentials.internal.sequencing.ServerSessionConnectionHandler;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.essentials.sequencing.DefaultSequence;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.sequencing.SequencingControl;
import oracle.toplink.essentials.sessions.Login;
import oracle.toplink.essentials.threetier.ConnectionPool;
import oracle.toplink.essentials.threetier.ExternalConnectionPool;
import oracle.toplink.essentials.threetier.ServerSession;

class SequencingManager
implements SequencingHome,
SequencingServer,
SequencingControl {
    private DatabaseSessionImpl ownerSession;
    private SequencingConnectionHandler connectionHandler;
    private PreallocationHandler preallocationHandler;
    private int whenShouldAcquireValueForAll;
    private Vector connectedSequences;
    boolean atLeastOneSequenceShouldUseTransaction;
    boolean atLeastOneSequenceShouldUsePreallocation;
    private static final int NOPREALLOCATION = 0;
    private static final int PREALLOCATION_NOTRANSACTION = 1;
    private static final int PREALLOCATION_TRANSACTION_NOACCESSOR = 2;
    private static final int PREALLOCATION_TRANSACTION_ACCESSOR = 3;
    private static final int NUMBER_OF_STATES = 4;
    private State[] states;
    private Hashtable locks;
    private SequencingCallback callback;
    private SequencingServer server;
    private Sequencing seq;
    private boolean shouldUseSeparateConnection;
    private Login login;
    private int minPoolSize;
    private int maxPoolSize;

    public SequencingManager(DatabaseSessionImpl ownerSession) {
        this.ownerSession = ownerSession;
    }

    protected DatabaseSessionImpl getOwnerSession() {
        return this.ownerSession;
    }

    protected void createConnectionHandler() {
        boolean isServerSession = this.getOwnerSession().isServerSession();
        if (this.getLogin() == null) {
            Login login = isServerSession ? ((ServerSession)this.getOwnerSession()).getReadConnectionPool().getLogin() : this.getOwnerSession().getDatasourceLogin();
            this.setLogin((Login)login.clone());
        }
        if (this.getLogin() != null && this.getLogin().shouldUseExternalTransactionController()) {
            throw ValidationException.invalidSequencingLogin();
        }
        if (isServerSession) {
            ConnectionPool pool = null;
            if (this.getLogin().shouldUseExternalConnectionPooling()) {
                pool = new ExternalConnectionPool("sequencing", this.getLogin(), (ServerSession)this.getOwnerSession());
            } else {
                if (this.getMinPoolSize() == 0 && this.getMaxPoolSize() == 0) {
                    this.setMinPoolSize(2);
                    this.setMaxPoolSize(2);
                }
                pool = new ConnectionPool("sequencing", this.getLogin(), this.getMinPoolSize(), this.getMaxPoolSize(), (ServerSession)this.getOwnerSession());
            }
            this.setConnectionHandler(new ServerSessionConnectionHandler(pool));
        } else {
            this.setConnectionHandler(new DatabaseSessionConnectionHandler(this.getOwnerSession(), this.getLogin()));
        }
    }

    public SequencingControl getSequencingControl() {
        return this;
    }

    protected void setSequencing(Sequencing sequencing) {
        this.seq = sequencing;
    }

    public Sequencing getSequencing() {
        return this.seq;
    }

    protected void setSequencingServer(SequencingServer server) {
        this.server = server;
    }

    public SequencingServer getSequencingServer() {
        return this.server;
    }

    protected void setSequencingCallback(SequencingCallback callback) {
        this.callback = callback;
    }

    public SequencingCallback getSequencingCallback() {
        return this.callback;
    }

    public boolean shouldUseSeparateConnection() {
        return this.shouldUseSeparateConnection;
    }

    public void setShouldUseSeparateConnection(boolean shouldUseSeparateConnection) {
        this.shouldUseSeparateConnection = shouldUseSeparateConnection;
    }

    public boolean isConnectedUsingSeparateConnection() {
        return this.isConnected() && this.getConnectionHandler() != null;
    }

    public Login getLogin() {
        return this.login;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int size) {
        this.minPoolSize = size;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int size) {
        this.maxPoolSize = size;
    }

    public boolean isConnected() {
        return this.states != null;
    }

    protected SequencingConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    protected void setConnectionHandler(SequencingConnectionHandler handler) {
        this.connectionHandler = handler;
    }

    public Object getNextValue(Class cls) {
        return this.getNextValue(this.getOwnerSession(), cls);
    }

    public void initializePreallocated() {
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().initializePreallocated();
        }
    }

    public void initializePreallocated(String seqName) {
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().initializePreallocated(seqName);
        }
    }

    protected void setLocks(Hashtable locks) {
        this.locks = locks;
    }

    protected Hashtable getLocks() {
        return this.locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireLock(String seqName) {
        ConcurrencyManager manager;
        Hashtable hashtable = this.getLocks();
        synchronized (hashtable) {
            manager = (ConcurrencyManager)this.getLocks().get(seqName);
            if (manager == null) {
                manager = new ConcurrencyManager();
                this.getLocks().put(seqName, manager);
            }
        }
        manager.acquire();
    }

    protected void releaseLock(String seqName) {
        ConcurrencyManager manager = (ConcurrencyManager)this.locks.get(seqName);
        manager.release();
    }

    protected Sequence getSequence(Class cls) {
        String seqName = this.getOwnerSession().getDescriptor(cls).getSequenceNumberName();
        return this.getSequence(seqName);
    }

    protected void logDebugPreallocation(String seqName, Vector sequences) {
        if (this.getOwnerSession().shouldLog(1, "sequencing")) {
            Object[] args = new Object[]{seqName, new Integer(sequences.size()), sequences.firstElement(), sequences.lastElement()};
            this.getOwnerSession().log(1, "sequencing", "sequencing_preallocation", args);
        }
    }

    protected void logDebugLocalPreallocation(AbstractSession writeSession, String seqName, Vector sequences, Accessor accessor) {
        if (writeSession.shouldLog(1, "sequencing")) {
            Object[] args = new Object[]{seqName, new Integer(sequences.size()), sequences.firstElement(), sequences.lastElement()};
            writeSession.log(1, "sequencing", "sequencing_localPreallocation", args, accessor);
        }
    }

    public void resetSequencing() {
        if (this.isConnected()) {
            this.onDisconnect();
            this.onConnect();
        }
    }

    public void onConnect() {
        if (this.isConnected()) {
            return;
        }
        if (!this.getOwnerSession().getProject().usesSequencing()) {
            return;
        }
        this.onConnectAllSequences();
        boolean onExceptionDisconnectPreallocationHandler = false;
        boolean onExceptionDisconnectConnectionHandler = false;
        try {
            if (!this.shouldUseSeparateConnection()) {
                this.setConnectionHandler(null);
            } else if (this.atLeastOneSequenceShouldUseTransaction) {
                if (this.getConnectionHandler() == null) {
                    this.createConnectionHandler();
                }
                if (this.getConnectionHandler() != null) {
                    this.getConnectionHandler().onConnect();
                    onExceptionDisconnectConnectionHandler = true;
                }
            }
            if (this.atLeastOneSequenceShouldUsePreallocation) {
                if (this.getPreallocationHandler() == null) {
                    this.createPreallocationHandler();
                }
                this.getPreallocationHandler().onConnect();
                onExceptionDisconnectPreallocationHandler = true;
            }
            this.initializeStates();
        }
        catch (RuntimeException ex) {
            this.onDisconnectAllSequences();
            if (this.getConnectionHandler() != null) {
                if (onExceptionDisconnectConnectionHandler) {
                    this.getConnectionHandler().onDisconnect();
                }
                this.setConnectionHandler(null);
            }
            if (this.getPreallocationHandler() != null) {
                if (onExceptionDisconnectPreallocationHandler) {
                    this.getPreallocationHandler().onDisconnect();
                }
                this.clearPreallocationHandler();
            }
            throw ex;
        }
        if (this.atLeastOneSequenceShouldUsePreallocation) {
            this.setLocks(new Hashtable(20));
        }
        this.createSequencingCallback();
        if (this.getOwnerSession().isServerSession()) {
            this.setSequencingServer(this);
        }
        this.setSequencing(this);
        this.logDebugSequencingConnected();
    }

    public void onDisconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.setSequencing(null);
        this.setSequencingServer(null);
        this.setSequencingCallback(null);
        this.setLocks(null);
        this.clearStates();
        if (this.getConnectionHandler() != null) {
            this.getConnectionHandler().onDisconnect();
            this.setConnectionHandler(null);
        }
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().onDisconnect();
            this.clearPreallocationHandler();
        }
        this.onDisconnectAllSequences();
        this.getOwnerSession().log(1, "sequencing", "sequencing_disconnected");
    }

    protected PreallocationHandler getPreallocationHandler() {
        return this.preallocationHandler;
    }

    protected void createPreallocationHandler() {
        this.preallocationHandler = new PreallocationHandler();
    }

    protected void clearPreallocationHandler() {
        this.preallocationHandler = null;
    }

    protected void onConnectAllSequences() {
        this.connectedSequences = new Vector();
        boolean shouldUseTransaction = false;
        boolean shouldUsePreallocation = false;
        boolean shouldAcquireValueAfterInsert = false;
        for (ClassDescriptor descriptor : this.getOwnerSession().getDescriptors().values()) {
            if (!descriptor.usesSequenceNumbers()) continue;
            String seqName = descriptor.getSequenceNumberName();
            Sequence sequence = this.getSequence(seqName);
            if (sequence == null) {
                sequence = new DefaultSequence(seqName);
                this.getOwnerSession().getDatasourcePlatform().addSequence(sequence);
            }
            if (this.connectedSequences.contains(sequence)) continue;
            try {
                if (sequence instanceof DefaultSequence && !this.connectedSequences.contains(this.getDefaultSequence())) {
                    this.getDefaultSequence().onConnect(this.getOwnerSession().getDatasourcePlatform());
                    this.connectedSequences.add(0, this.getDefaultSequence());
                    shouldUseTransaction |= this.getDefaultSequence().shouldUseTransaction();
                    shouldUsePreallocation |= this.getDefaultSequence().shouldUsePreallocation();
                    shouldAcquireValueAfterInsert |= this.getDefaultSequence().shouldAcquireValueAfterInsert();
                }
                sequence.onConnect(this.getOwnerSession().getDatasourcePlatform());
                this.connectedSequences.addElement(sequence);
                shouldUseTransaction |= sequence.shouldUseTransaction();
                shouldUsePreallocation |= sequence.shouldUsePreallocation();
                shouldAcquireValueAfterInsert |= sequence.shouldAcquireValueAfterInsert();
            }
            catch (RuntimeException ex) {
                for (int i = this.connectedSequences.size() - 1; i >= 0; --i) {
                    try {
                        Sequence sequenceToDisconnect = (Sequence)this.connectedSequences.elementAt(i);
                        sequenceToDisconnect.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                        continue;
                    }
                    catch (RuntimeException ex2) {
                        // empty catch block
                    }
                }
                this.connectedSequences = null;
                throw ex;
            }
        }
        if (shouldAcquireValueAfterInsert && !shouldUsePreallocation) {
            this.whenShouldAcquireValueForAll = 1;
        } else if (!shouldAcquireValueAfterInsert && shouldUsePreallocation) {
            this.whenShouldAcquireValueForAll = -1;
        }
        this.atLeastOneSequenceShouldUseTransaction = shouldUseTransaction;
        this.atLeastOneSequenceShouldUsePreallocation = shouldUsePreallocation;
    }

    protected void onDisconnectAllSequences() {
        RuntimeException exception = null;
        for (int i = this.connectedSequences.size() - 1; i >= 0; --i) {
            try {
                Sequence sequenceToDisconnect = (Sequence)this.connectedSequences.elementAt(i);
                sequenceToDisconnect.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                continue;
            }
            catch (RuntimeException ex) {
                if (exception != null) continue;
                exception = ex;
            }
        }
        this.connectedSequences = null;
        this.whenShouldAcquireValueForAll = 0;
        this.atLeastOneSequenceShouldUseTransaction = false;
        this.atLeastOneSequenceShouldUsePreallocation = false;
        if (exception != null) {
            throw exception;
        }
    }

    protected void initializeStates() {
        this.states = new State[4];
        for (Sequence sequence : this.connectedSequences) {
            State state = this.getState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
            if (state != null) continue;
            this.createState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
        }
    }

    protected void clearStates() {
        this.states = null;
    }

    protected int getStateId(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        if (!shouldUsePreallocation) {
            return 0;
        }
        if (!shouldUseTransaction) {
            return 1;
        }
        if (this.getConnectionHandler() == null) {
            return 2;
        }
        return 3;
    }

    protected State getState(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        return this.states[this.getStateId(shouldUsePreallocation, shouldUseTransaction)];
    }

    protected void createState(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        if (!shouldUsePreallocation) {
            this.states[0] = new NoPreallocation_State();
        } else if (!shouldUseTransaction) {
            this.states[1] = new Preallocation_NoTransaction_State();
        } else if (this.getConnectionHandler() == null) {
            this.states[2] = new Preallocation_Transaction_NoAccessor_State();
        } else {
            this.states[3] = new Preallocation_Transaction_Accessor_State();
        }
    }

    protected void createSequencingCallback() {
        Vector<SequencingCallback> callbackVector = new Vector<SequencingCallback>();
        for (int i = 0; i < 4; ++i) {
            SequencingCallback callback;
            if (this.states[i] == null || (callback = this.states[i].getSequencingCallback()) == null) continue;
            callbackVector.addElement(callback);
        }
        if (callbackVector.isEmpty()) {
            this.setSequencingCallback(null);
        } else if (callbackVector.size() == 1) {
            this.setSequencingCallback((SequencingCallback)callbackVector.firstElement());
        } else {
            this.setSequencingCallback(new SequencingCallbackContainer(callbackVector));
        }
    }

    public Object getNextValue(AbstractSession writeSession, Class cls) {
        Sequence sequence = this.getSequence(cls);
        State state = this.getState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
        return state.getNextValue(sequence, writeSession);
    }

    protected void logDebugSequencingConnected() {
        Vector[] sequenceVectors = new Vector[4];
        for (Sequence sequence : this.connectedSequences) {
            int stateId = this.getStateId(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
            Vector<Sequence> v = sequenceVectors[stateId];
            if (v == null) {
                sequenceVectors[stateId] = v = new Vector<Sequence>();
            }
            v.addElement(sequence);
        }
        for (int i = 0; i < 4; ++i) {
            Vector v = sequenceVectors[i];
            if (v == null) continue;
            this.getOwnerSession().log(1, "sequencing", "sequencing_connected", this.states[i]);
            for (int j = 0; j < v.size(); ++j) {
                Sequence sequence = (Sequence)v.elementAt(j);
                Object[] args = new Object[]{sequence.getName(), Integer.toString(sequence.getPreallocationSize()), Integer.toString(sequence.getInitialValue())};
                this.getOwnerSession().log(1, "sequencing", "sequence_without_state", args);
            }
        }
    }

    public int getPreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    public int getInitialValue() {
        return this.getDefaultSequence().getInitialValue();
    }

    public boolean shouldAcquireValueAfterInsert(Class cls) {
        return this.getSequence(cls).shouldAcquireValueAfterInsert();
    }

    public boolean shouldOverrideExistingValue(Class cls, Object existingValue) {
        return this.getSequence(cls).shouldOverrideExistingValue(existingValue);
    }

    public int whenShouldAcquireValueForAll() {
        return this.whenShouldAcquireValueForAll;
    }

    protected Sequence getDefaultSequence() {
        return this.getOwnerSession().getDatasourcePlatform().getDefaultSequence();
    }

    protected Sequence getSequence(String seqName) {
        return this.getOwnerSession().getDatasourcePlatform().getSequence(seqName);
    }

    static class SequencingCallbackContainer
    implements SequencingCallback {
        SequencingCallback[] callbackArray;

        SequencingCallbackContainer(Vector callbackVector) {
            this.callbackArray = new SequencingCallback[callbackVector.size()];
            callbackVector.copyInto(this.callbackArray);
        }

        public void afterTransaction(Accessor accessor, boolean committed) {
            for (int i = 0; i < this.callbackArray.length; ++i) {
                this.callbackArray[i].afterTransaction(accessor, committed);
            }
        }
    }

    class NoPreallocation_State
    extends State {
        NoPreallocation_State() {
        }

        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            return sequence.getGeneratedValue(null, writeSession);
        }
    }

    class Preallocation_NoTransaction_State
    extends State {
        Preallocation_NoTransaction_State() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            Object sequenceValue;
            String seqName = sequence.getName();
            SequencingManager.this.acquireLock(seqName);
            try {
                Vector sequencesForName = SequencingManager.this.getPreallocationHandler().getPreallocated(seqName);
                if (sequencesForName.isEmpty()) {
                    Vector sequences = sequence.getGeneratedVector(null, writeSession);
                    SequencingManager.this.getPreallocationHandler().setPreallocated(seqName, sequences);
                    SequencingManager.this.logDebugPreallocation(seqName, sequences);
                }
                sequenceValue = sequencesForName.firstElement();
                sequencesForName.removeElementAt(0);
            }
            finally {
                SequencingManager.this.releaseLock(seqName);
            }
            return sequenceValue;
        }
    }

    class Preallocation_Transaction_Accessor_State
    extends State {
        Preallocation_Transaction_Accessor_State() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            Object sequenceValue = null;
            String seqName = sequence.getName();
            SequencingManager.this.acquireLock(seqName);
            try {
                Vector sequencesForName = SequencingManager.this.getPreallocationHandler().getPreallocated(seqName);
                if (sequencesForName.isEmpty()) {
                    Accessor accessor = null;
                    try {
                        accessor = SequencingManager.this.getConnectionHandler().acquireAccessor();
                        accessor.beginTransaction(writeSession);
                        Vector sequences = sequence.getGeneratedVector(accessor, writeSession);
                        SequencingManager.this.getPreallocationHandler().setPreallocated(seqName, sequences);
                        accessor.commitTransaction(writeSession);
                        SequencingManager.this.logDebugPreallocation(seqName, sequences);
                    }
                    catch (RuntimeException ex) {
                        sequencesForName.clear();
                        try {
                            accessor.rollbackTransaction(writeSession);
                        }
                        catch (Exception rollbackException) {
                            // empty catch block
                        }
                        throw ex;
                    }
                    finally {
                        SequencingManager.this.getConnectionHandler().releaseAccessor(accessor);
                    }
                }
                sequenceValue = sequencesForName.firstElement();
                sequencesForName.removeElementAt(0);
            }
            finally {
                SequencingManager.this.releaseLock(seqName);
            }
            return sequenceValue;
        }
    }

    class Preallocation_Transaction_NoAccessor_State
    extends State
    implements SequencingCallback {
        protected Hashtable accessorToPreallocated = new Hashtable(20);

        Preallocation_Transaction_NoAccessor_State() {
        }

        SequencingCallback getSequencingCallback() {
            return this;
        }

        public void afterTransaction(Accessor accessor, boolean committed) {
            Hashtable localSequences = (Hashtable)this.accessorToPreallocated.get(accessor);
            if (localSequences != null) {
                if (committed) {
                    Enumeration enumtr = localSequences.keys();
                    while (enumtr.hasMoreElements()) {
                        String seqName = (String)enumtr.nextElement();
                        Vector localSequenceForName = (Vector)localSequences.get(seqName);
                        if (localSequenceForName.isEmpty()) continue;
                        SequencingManager.this.acquireLock(seqName);
                        SequencingManager.this.getPreallocationHandler().setPreallocated(seqName, localSequenceForName);
                        localSequenceForName.clear();
                        SequencingManager.this.releaseLock(seqName);
                    }
                }
                this.accessorToPreallocated.remove(accessor);
                if (committed) {
                    SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionCommitted", null, accessor);
                } else {
                    SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionRolledBack", null, accessor);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            Vector localSequencesForName;
            Accessor accessor;
            String seqName = sequence.getName();
            SequencingManager.this.acquireLock(seqName);
            boolean keepLocked = false;
            Vector sequencesForName = SequencingManager.this.getPreallocationHandler().getPreallocated(seqName);
            try {
                if (!sequencesForName.isEmpty()) {
                    Object sequenceValue = sequencesForName.firstElement();
                    sequencesForName.removeElementAt(0);
                    Object e = sequenceValue;
                    return e;
                }
                if (!SequencingManager.this.getOwnerSession().getDatasourceLogin().shouldUseExternalTransactionController() && sequence.getPreallocationSize() > 1 && !writeSession.isInTransaction()) {
                    writeSession.beginTransaction();
                    keepLocked = true;
                }
            }
            finally {
                if (!keepLocked) {
                    SequencingManager.this.releaseLock(seqName);
                }
            }
            if (!keepLocked) {
                writeSession.beginTransaction();
            }
            try {
                accessor = writeSession.getAccessor();
                Hashtable<String, Vector> localSequences = (Hashtable<String, Vector>)this.accessorToPreallocated.get(accessor);
                if (localSequences == null) {
                    localSequences = new Hashtable<String, Vector>(20);
                    this.accessorToPreallocated.put(accessor, localSequences);
                }
                if ((localSequencesForName = (Vector)localSequences.get(seqName)) == null || localSequencesForName.isEmpty()) {
                    localSequencesForName = sequence.getGeneratedVector(null, writeSession);
                    localSequences.put(seqName, localSequencesForName);
                    SequencingManager.this.logDebugLocalPreallocation(writeSession, seqName, localSequencesForName, accessor);
                }
            }
            catch (RuntimeException ex) {
                if (keepLocked) {
                    SequencingManager.this.releaseLock(seqName);
                }
                try {
                    writeSession.rollbackTransaction();
                }
                catch (Exception rollbackException) {
                    // empty catch block
                }
                throw ex;
            }
            if (!keepLocked) {
                SequencingManager.this.acquireLock(seqName);
            }
            try {
                Object sequenceValue;
                try {
                    writeSession.commitTransaction();
                }
                catch (DatabaseException ex) {
                    try {
                        writeSession.rollbackTransaction();
                    }
                    catch (Exception rollbackException) {
                        // empty catch block
                    }
                    throw ex;
                }
                if (!localSequencesForName.isEmpty()) {
                    Object sequenceValue2 = localSequencesForName.firstElement();
                    localSequencesForName.removeElementAt(0);
                    Object ex = sequenceValue2;
                    return ex;
                }
                try {
                    sequenceValue = sequencesForName.firstElement();
                }
                catch (NoSuchElementException ex) {
                    throw ConcurrencyException.sequencingMultithreadThruConnection(String.valueOf(System.identityHashCode(accessor)));
                }
                sequencesForName.removeElementAt(0);
                Object e = sequenceValue;
                return e;
            }
            finally {
                SequencingManager.this.releaseLock(seqName);
            }
        }
    }

    static abstract class State {
        State() {
        }

        abstract Object getNextValue(Sequence var1, AbstractSession var2);

        SequencingCallback getSequencingCallback() {
            return null;
        }

        public String toString() {
            String name = this.getClass().getName();
            return name.substring(name.lastIndexOf(36) + 1);
        }
    }
}

