/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.AggregateChangeRecord;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.AggregateMapping;
import oracle.toplink.essentials.mappings.Association;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.RelationalMapping;
import oracle.toplink.essentials.queryframework.ObjectBuildingQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateObjectMapping
extends AggregateMapping
implements RelationalMapping {
    protected boolean isNullAllowed = true;
    protected transient Map<String, String> aggregateToSourceFieldNames = new HashMap<String, String>(5);

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public void addFieldNameTranslation(String sourceFieldName, String aggregateFieldName) {
        String unQualifiedAggregateFieldName = aggregateFieldName.substring(aggregateFieldName.lastIndexOf(46) + 1);
        this.getAggregateToSourceFieldNames().put(unQualifiedAggregateFieldName, sourceFieldName);
    }

    protected boolean allAggregateFieldsAreNull(AbstractRecord databaseRow) {
        Enumeration<DatabaseField> fieldsEnum = this.getReferenceFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField field = fieldsEnum.nextElement();
            Object value = databaseRow.get(field);
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public void allowNull() {
        this.setIsNullAllowed(true);
    }

    protected boolean backupAttributeValueIsNull(WriteObjectQuery query) {
        Object backupAttributeValue;
        return query.getSession().isUnitOfWork() && (backupAttributeValue = this.getAttributeValueFromObject(query.getBackupClone())) == null;
    }

    protected Object buildAggregateFromRow(AbstractRecord databaseRow, Object targetObject, JoinedAttributeManager joinManager, boolean buildShallowOriginal, AbstractSession session) throws DatabaseException {
        if (this.isNullAllowed() && this.allAggregateFieldsAreNull(databaseRow)) {
            return null;
        }
        Object aggregate = null;
        ClassDescriptor descriptor = this.getReferenceDescriptor();
        boolean refreshing = true;
        if (descriptor.hasInheritance()) {
            Class newAggregateClass = descriptor.getInheritancePolicy().classFromRow(databaseRow, session);
            descriptor = this.getReferenceDescriptor(newAggregateClass, session);
            if (joinManager.getBaseQuery().shouldRefreshIdentityMapResult() && (aggregate = this.getMatchingAttributeValueFromObject(databaseRow, targetObject, session, descriptor)) != null && aggregate.getClass() != newAggregateClass) {
                aggregate = descriptor.getObjectBuilder().buildNewInstance();
                refreshing = false;
            }
        } else if (joinManager.getBaseQuery().shouldRefreshIdentityMapResult()) {
            aggregate = this.getMatchingAttributeValueFromObject(databaseRow, targetObject, session, descriptor);
        }
        if (aggregate == null) {
            aggregate = descriptor.getObjectBuilder().buildNewInstance();
            refreshing = false;
        }
        ObjectBuildingQuery nestedQuery = joinManager.getBaseQuery();
        nestedQuery.setSession(session);
        if (joinManager.getBaseQuery().isObjectLevelReadQuery() && joinManager.isAttributeJoined(this.getDescriptor(), this.getAttributeName())) {
            nestedQuery = (ObjectLevelReadQuery)((ObjectLevelReadQuery)joinManager.getBaseQuery()).deepClone();
            ((ObjectLevelReadQuery)nestedQuery).getJoinedAttributeManager().setJoinedAttributeExpressions_(this.extractNestedExpressions(joinManager.getJoinedAttributeExpressions(), joinManager.getBaseExpressionBuilder(), false));
            nestedQuery.setDescriptor(descriptor);
        }
        if (buildShallowOriginal) {
            descriptor.getObjectBuilder().buildAttributesIntoShallowObject(aggregate, databaseRow, nestedQuery);
        } else if (session.isUnitOfWork()) {
            descriptor.getObjectBuilder().buildAttributesIntoWorkingCopyClone(aggregate, nestedQuery, joinManager, databaseRow, (UnitOfWorkImpl)session, refreshing);
        } else {
            descriptor.getObjectBuilder().buildAttributesIntoObject(aggregate, databaseRow, nestedQuery, joinManager, refreshing);
        }
        return aggregate;
    }

    protected AbstractRecord buildNullReferenceRow() {
        DatabaseRecord result = new DatabaseRecord(this.getReferenceFields().size());
        Enumeration<DatabaseField> stream = this.getReferenceFields().elements();
        while (stream.hasMoreElements()) {
            result.put(stream.nextElement(), (Object)null);
        }
        return result;
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Object value, AbstractSession session) {
        Expression attributeByAttributeComparison = null;
        Expression join = null;
        Object attributeValue = null;
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor();
        if (value != null && !referenceDescriptor.getJavaClass().isInstance(value)) {
            throw QueryException.incorrectClassForObjectComparison(expression, value, this);
        }
        Enumeration<DatabaseMapping> mappings = referenceDescriptor.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            attributeValue = value == null ? null : mapping.getAttributeValueFromObject(value);
            join = expression.get(mapping.getAttributeName()).equal(attributeValue);
            if (attributeByAttributeComparison == null) {
                attributeByAttributeComparison = join;
                continue;
            }
            attributeByAttributeComparison = attributeByAttributeComparison.and(join);
        }
        return attributeByAttributeComparison;
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Expression argument, AbstractSession session) {
        Expression attributeByAttributeComparison = null;
        Enumeration<DatabaseMapping> mappingsEnum = this.getReferenceDescriptor().getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsEnum.nextElement();
            String attributeName = mapping.getAttributeName();
            Expression join = expression.get(attributeName).equal(argument.get(attributeName));
            if (attributeByAttributeComparison == null) {
                attributeByAttributeComparison = join;
                continue;
            }
            attributeByAttributeComparison = attributeByAttributeComparison.and(join);
        }
        return attributeByAttributeComparison;
    }

    protected AbstractRecord buildRowFromAggregate(Object object, Object attributeValue, AbstractSession session) throws DescriptorException {
        return this.buildRowFromAggregate(object, attributeValue, session, false);
    }

    protected AbstractRecord buildRowFromAggregate(Object object, Object attributeValue, AbstractSession session, boolean forceWriteOfReadOnlyClasses) throws DescriptorException {
        if (attributeValue == null) {
            if (this.isNullAllowed()) {
                return this.buildNullReferenceRow();
            }
            throw DescriptorException.nullForNonNullAggregate(object, this);
        }
        if (!forceWriteOfReadOnlyClasses && session.isClassReadOnly(attributeValue.getClass())) {
            return new DatabaseRecord(1);
        }
        return this.getObjectBuilder(attributeValue, session).buildRow(attributeValue, session);
    }

    protected AbstractRecord buildRowFromAggregateWithChangeRecord(ChangeRecord changeRecord, ObjectChangeSet objectChangeSet, AbstractSession session) throws DescriptorException {
        return this.buildRowFromAggregateWithChangeRecord(changeRecord, objectChangeSet, session, false);
    }

    protected AbstractRecord buildRowFromAggregateWithChangeRecord(ChangeRecord changeRecord, ObjectChangeSet objectChangeSet, AbstractSession session, boolean forceWriteOfReadOnlyClasses) throws DescriptorException {
        if (objectChangeSet == null) {
            if (this.isNullAllowed()) {
                return this.buildNullReferenceRow();
            }
            Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
            throw DescriptorException.nullForNonNullAggregate(object, this);
        }
        if (!forceWriteOfReadOnlyClasses && session.isClassReadOnly(objectChangeSet.getClassType(session))) {
            return new DatabaseRecord(1);
        }
        return this.getReferenceDescriptor(objectChangeSet.getClassType(session), session).getObjectBuilder().buildRowWithChangeSet(objectChangeSet, session);
    }

    protected AbstractRecord buildRowFromAggregateForUpdate(WriteObjectQuery query, Object attributeValue) throws DescriptorException {
        if (attributeValue == null) {
            if (this.isNullAllowed()) {
                if (this.backupAttributeValueIsNull(query)) {
                    return new DatabaseRecord(1);
                }
                return this.buildNullReferenceRow();
            }
            throw DescriptorException.nullForNonNullAggregate(query.getObject(), this);
        }
        if (!(query.getBackupClone() == null || this.getMatchingBackupAttributeValue(query, attributeValue) != null && attributeValue.getClass().equals(this.getMatchingBackupAttributeValue(query, attributeValue).getClass()))) {
            return this.getObjectBuilder(attributeValue, query.getSession()).buildRow(attributeValue, query.getSession());
        }
        if (query.getSession().isClassReadOnly(attributeValue.getClass())) {
            return new DatabaseRecord(1);
        }
        WriteObjectQuery clonedQuery = (WriteObjectQuery)query.clone();
        clonedQuery.setObject(attributeValue);
        if (query.getSession().isUnitOfWork()) {
            Object backupAttributeValue = this.getMatchingBackupAttributeValue(query, attributeValue);
            if (backupAttributeValue == null) {
                backupAttributeValue = this.getObjectBuilder(attributeValue, query.getSession()).buildNewInstance();
            }
            clonedQuery.setBackupClone(backupAttributeValue);
        }
        return this.getObjectBuilder(attributeValue, query.getSession()).buildRowForUpdate(clonedQuery);
    }

    @Override
    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        Object aggregateClone = this.buildClonePart(original, attributeValue, unitOfWork);
        if (aggregateClone != null) {
            ClassDescriptor descriptor = this.getReferenceDescriptor(aggregateClone, (AbstractSession)unitOfWork);
            descriptor.getObjectChangePolicy().setAggregateChangeListener(clone, aggregateClone, unitOfWork, descriptor, this.getAttributeName());
        }
        this.setAttributeValueInObject(clone, aggregateClone);
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Object clonedAttributeValue = this.buildAggregateFromRow(databaseRow, clone, joinManager, false, executionSession);
        ClassDescriptor descriptor = this.getReferenceDescriptor(clonedAttributeValue, (AbstractSession)unitOfWork);
        descriptor.getObjectChangePolicy().setAggregateChangeListener(clone, clonedAttributeValue, unitOfWork, descriptor, this.getAttributeName());
        this.setAttributeValueInObject(clone, clonedAttributeValue);
    }

    public void buildShallowOriginalFromRow(AbstractRecord databaseRow, Object original, JoinedAttributeManager joinManager, AbstractSession executionSession) {
        Object aggregate = this.buildAggregateFromRow(databaseRow, original, joinManager, true, executionSession);
        this.setAttributeValueInObject(original, aggregate);
    }

    protected AbstractRecord buildTemplateInsertRow(AbstractSession session) {
        AbstractRecord result = this.getReferenceDescriptor().getObjectBuilder().buildTemplateInsertRow(session);
        List processedMappings = (List)this.getReferenceDescriptor().getMappings().clone();
        if (this.getReferenceDescriptor().hasInheritance()) {
            Enumeration children = this.getReferenceDescriptor().getInheritancePolicy().getChildDescriptors().elements();
            while (children.hasMoreElements()) {
                Enumeration<DatabaseMapping> mappings = ((ClassDescriptor)children.nextElement()).getMappings().elements();
                while (mappings.hasMoreElements()) {
                    DatabaseMapping mapping = mappings.nextElement();
                    if (processedMappings.contains(mapping)) continue;
                    mapping.writeInsertFieldsIntoRow(result, session);
                    processedMappings.add(mapping);
                }
            }
        }
        return result;
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
        Object objectReferenced = this.getRealAttributeValueFromObject(object, uow);
        if (objectReferenced == null) {
            return;
        }
        if (!visitedObjects.contains(objectReferenced)) {
            visitedObjects.put(objectReferenced, objectReferenced);
            ObjectBuilder builder = this.getReferenceDescriptor(objectReferenced.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadePerformRemove(objectReferenced, uow, visitedObjects);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
        Object objectReferenced = this.getRealAttributeValueFromObject(object, uow);
        if (objectReferenced == null) {
            return;
        }
        if (!visitedObjects.contains(objectReferenced)) {
            visitedObjects.put(objectReferenced, objectReferenced);
            ObjectBuilder builder = this.getReferenceDescriptor(objectReferenced.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadeRegisterNewForCreate(objectReferenced, uow, visitedObjects);
        }
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        return this.getReferenceFields();
    }

    public void dontAllowNull() {
        this.setIsNullAllowed(false);
    }

    public Vector<Association> getAggregateToSourceFieldNameAssociations() {
        Vector<Association> associations = new Vector<Association>(this.getAggregateToSourceFieldNames().size());
        Iterator<String> aggregateEnum = this.getAggregateToSourceFieldNames().keySet().iterator();
        Iterator<String> sourceEnum = this.getAggregateToSourceFieldNames().values().iterator();
        while (aggregateEnum.hasNext()) {
            associations.addElement(new Association(aggregateEnum.next(), sourceEnum.next()));
        }
        return associations;
    }

    public Map<String, String> getAggregateToSourceFieldNames() {
        return this.aggregateToSourceFieldNames;
    }

    @Override
    public Class getFieldClassification(DatabaseField fieldToClassify) {
        DatabaseMapping mapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForField(fieldToClassify);
        if (mapping == null) {
            return null;
        }
        return mapping.getFieldClassification(fieldToClassify);
    }

    protected Object getMatchingAttributeValueFromObject(AbstractRecord row, Object targetObject, AbstractSession session, ClassDescriptor descriptor) {
        return this.getAttributeValueFromObject(targetObject);
    }

    protected Object getMatchingBackupAttributeValue(WriteObjectQuery query, Object attributeValue) {
        return this.getAttributeValueFromObject(query.getBackupClone());
    }

    @Override
    protected ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.getReferenceDescriptor().getJavaClass().equals(theClass)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor subclassDescriptor = this.getReferenceDescriptor().getInheritancePolicy().getSubclassDescriptor(theClass);
        if (subclassDescriptor == null) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subclassDescriptor;
    }

    protected Vector<DatabaseField> getReferenceFields() {
        return this.getReferenceDescriptor().getAllFields();
    }

    @Override
    public boolean hasDependency() {
        return this.getReferenceDescriptor().hasDependencyOnParts();
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        ClassDescriptor clonedDescriptor = (ClassDescriptor)this.getReferenceDescriptor().clone();
        if (clonedDescriptor.isChildDescriptor()) {
            ClassDescriptor parentDescriptor = session.getDescriptor(clonedDescriptor.getInheritancePolicy().getParentClass());
            this.initializeParentInheritance(parentDescriptor, clonedDescriptor, session);
        }
        this.setReferenceDescriptor(clonedDescriptor);
        this.initializeReferenceDescriptor(clonedDescriptor);
        clonedDescriptor.preInitialize(session);
        clonedDescriptor.initialize(session);
        this.translateFields(clonedDescriptor, session);
        if (clonedDescriptor.hasInheritance() && clonedDescriptor.getInheritancePolicy().hasChildren()) {
            this.initializeChildInheritance(clonedDescriptor, session);
        }
        this.setFields(this.collectFields());
    }

    public void initializeChildInheritance(ClassDescriptor parentDescriptor, AbstractSession session) throws DescriptorException {
        if (parentDescriptor.getInheritancePolicy().hasChildren()) {
            Vector childDescriptors = parentDescriptor.getInheritancePolicy().getChildDescriptors();
            NonSynchronizedVector cloneChildDescriptors = NonSynchronizedVector.newInstance();
            Enumeration enumtr = childDescriptors.elements();
            while (enumtr.hasMoreElements()) {
                ClassDescriptor clonedChildDescriptor = (ClassDescriptor)((ClassDescriptor)enumtr.nextElement()).clone();
                clonedChildDescriptor.getInheritancePolicy().setParentDescriptor(parentDescriptor);
                this.initializeReferenceDescriptor(clonedChildDescriptor);
                clonedChildDescriptor.preInitialize(session);
                clonedChildDescriptor.initialize(session);
                this.translateFields(clonedChildDescriptor, session);
                ((Vector)cloneChildDescriptors).addElement(clonedChildDescriptor);
                this.initializeChildInheritance(clonedChildDescriptor, session);
            }
            parentDescriptor.getInheritancePolicy().setChildDescriptors(cloneChildDescriptors);
        }
    }

    public void initializeParentInheritance(ClassDescriptor parentDescriptor, ClassDescriptor childDescriptor, AbstractSession session) throws DescriptorException {
        ClassDescriptor clonedParentDescriptor = (ClassDescriptor)parentDescriptor.clone();
        if (clonedParentDescriptor.getInheritancePolicy().isChildDescriptor()) {
            ClassDescriptor parentToParentDescriptor = session.getDescriptor(clonedParentDescriptor.getJavaClass());
            this.initializeParentInheritance(parentToParentDescriptor, parentDescriptor, session);
        }
        this.initializeReferenceDescriptor(clonedParentDescriptor);
        NonSynchronizedVector children = NonSynchronizedVector.newInstance(1);
        ((Vector)children).addElement(childDescriptor);
        clonedParentDescriptor.getInheritancePolicy().setChildDescriptors(children);
        clonedParentDescriptor.preInitialize(session);
        clonedParentDescriptor.initialize(session);
        this.translateFields(clonedParentDescriptor, session);
    }

    protected void initializeReferenceDescriptor(ClassDescriptor clonedDescriptor) {
        clonedDescriptor.setDefaultTable(this.getDescriptor().getDefaultTable());
        clonedDescriptor.setTables(this.getDescriptor().getTables());
        clonedDescriptor.setPrimaryKeyFields(this.getDescriptor().getPrimaryKeyFields());
    }

    @Override
    public boolean isAggregateObjectMapping() {
        return true;
    }

    @Override
    public boolean isChangeTrackingSupported() {
        return false;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    public boolean isNullAllowed() {
        return this.isNullAllowed;
    }

    @Override
    public void postInitialize(AbstractSession session) throws DescriptorException {
        super.postInitialize(session);
        if (this.getReferenceDescriptor() != null) {
            this.getReferenceDescriptor().postInitialize(session);
        }
    }

    public Object readFromReturnRowIntoObject(AbstractRecord row, Object targetObject, ReadObjectQuery query, Collection handledMappings) throws DatabaseException {
        Object aggregate = this.getAttributeValueFromObject(targetObject);
        if (aggregate == null) {
            aggregate = this.readFromRowIntoObject(row, null, targetObject, query);
            handledMappings.add(this);
            return aggregate;
        }
        for (int i = 0; i < this.getReferenceFields().size(); ++i) {
            DatabaseField field = this.getReferenceFields().elementAt(i);
            if (!row.containsKey(field)) continue;
            this.getObjectBuilder(aggregate, query.getSession()).assignReturnValueForField(aggregate, query, row, field, handledMappings);
        }
        if (this.isNullAllowed()) {
            boolean allAttributesNull = true;
            for (int i = 0; i < this.getReferenceFields().size() && allAttributesNull; ++i) {
                DatabaseField field = (DatabaseField)this.fields.elementAt(i);
                if (row.containsKey(field)) {
                    allAttributesNull = row.get(field) == null;
                    continue;
                }
                Object fieldValue = this.valueFromObject(targetObject, field, query.getSession());
                if (fieldValue == null) {
                    ForeignReferenceMapping refMapping;
                    DatabaseMapping baseMapping;
                    Object baseValue = this.getDescriptor().getObjectBuilder().getBaseValueForField(field, targetObject);
                    if (baseValue == null || !(baseMapping = this.getDescriptor().getObjectBuilder().getBaseMappingForField(field)).isForeignReferenceMapping() || !(refMapping = (ForeignReferenceMapping)baseMapping).usesIndirection()) continue;
                    allAttributesNull = refMapping.getIndirectionPolicy().objectIsInstantiated(baseValue);
                    continue;
                }
                allAttributesNull = false;
            }
            if (allAttributesNull) {
                aggregate = null;
                this.setAttributeValueInObject(targetObject, aggregate);
            }
        }
        handledMappings.add(this);
        return aggregate;
    }

    @Override
    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        Object aggregate = this.buildAggregateFromRow(databaseRow, targetObject, joinManager, false, executionSession);
        this.setAttributeValueInObject(targetObject, aggregate);
        return aggregate;
    }

    @Override
    public void rehashFieldDependancies(AbstractSession session) {
        this.getReferenceDescriptor().rehashFieldDependancies(session);
    }

    public void setAggregateToSourceFieldNameAssociations(Vector<Association> fieldAssociations) {
        Hashtable<String, String> fieldNames = new Hashtable<String, String>(fieldAssociations.size() + 1);
        Enumeration<Association> associationsEnum = fieldAssociations.elements();
        while (associationsEnum.hasMoreElements()) {
            Association association = associationsEnum.nextElement();
            fieldNames.put((String)association.getKey(), (String)association.getValue());
        }
        this.setAggregateToSourceFieldNames(fieldNames);
    }

    protected void setAggregateToSourceFieldNames(Map<String, String> aggregateToSource) {
        this.aggregateToSourceFieldNames = aggregateToSource;
    }

    public void setIsNullAllowed(boolean aBoolean) {
        this.isNullAllowed = aBoolean;
    }

    protected void translateFields(ClassDescriptor clonedDescriptor, AbstractSession session) {
        Enumeration<DatabaseField> entry = clonedDescriptor.getFields().elements();
        while (entry.hasMoreElements()) {
            DatabaseField field = entry.nextElement();
            String nameInAggregate = field.getName();
            String nameInSource = this.getAggregateToSourceFieldNames().get(nameInAggregate);
            if (nameInSource == null) continue;
            DatabaseField fieldInSource = new DatabaseField(nameInSource);
            if (fieldInSource.getName().equals(nameInSource)) {
                field.setName(nameInSource);
                continue;
            }
            field.setName(fieldInSource.getName());
            field.setTable(clonedDescriptor.getTable(fieldInSource.getTable().getName()));
        }
        clonedDescriptor.rehashFieldDependancies(session);
    }

    @Override
    public void writeFromAttributeIntoRow(Object attribute, AbstractRecord row, AbstractSession session) {
        AbstractRecord targetRow = this.buildRowFromAggregate(null, attribute, session);
        Enumeration stream = targetRow.keys();
        while (stream.hasMoreElements()) {
            DatabaseField field = (DatabaseField)stream.nextElement();
            Object value = targetRow.get(field);
            row.put(field, value);
        }
    }

    @Override
    public Object valueFromObject(Object object, DatabaseField field, AbstractSession session) throws DescriptorException {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            if (this.isNullAllowed()) {
                return null;
            }
            throw DescriptorException.nullForNonNullAggregate(object, this);
        }
        return this.getObjectBuilder(attributeValue, session).extractValueFromObjectForField(attributeValue, field, session);
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord databaseRow, AbstractSession session) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        AbstractRecord targetRow = this.buildRowFromAggregate(object, this.getAttributeValueFromObject(object), session);
        Enumeration stream = targetRow.keys();
        while (stream.hasMoreElements()) {
            DatabaseField field = (DatabaseField)stream.nextElement();
            Object value = targetRow.get(field);
            databaseRow.add(field, value);
        }
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord databaseRow, AbstractSession session) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        AbstractRecord targetRow = this.buildRowFromAggregateWithChangeRecord(changeRecord, (ObjectChangeSet)((AggregateChangeRecord)changeRecord).getChangedObject(), session);
        Enumeration stream = targetRow.keys();
        while (stream.hasMoreElements()) {
            DatabaseField field = (DatabaseField)stream.nextElement();
            Object value = targetRow.get(field);
            databaseRow.add(field, value);
        }
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery query, AbstractRecord databaseRow) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        AbstractRecord targetRow = this.buildRowFromAggregateForUpdate(query, this.getAttributeValueFromObject(query.getObject()));
        Enumeration stream = targetRow.keys();
        while (stream.hasMoreElements()) {
            DatabaseField field = (DatabaseField)stream.nextElement();
            Object value = targetRow.get(field);
            databaseRow.add(field, value);
        }
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        AbstractRecord targetRow = this.buildTemplateInsertRow(session);
        Enumeration keyEnum = targetRow.keys();
        while (keyEnum.hasMoreElements()) {
            DatabaseField field = (DatabaseField)keyEnum.nextElement();
            Object value = targetRow.get(field);
            databaseRow.add(field, value);
        }
    }

    public void addPrimaryKeyJoinField(DatabaseField primaryKeyField, DatabaseField secondaryField) {
        ObjectBuilder builder = this.getReferenceDescriptor().getObjectBuilder();
        DatabaseMapping mapping = builder.getMappingForField(primaryKeyField);
        if (mapping != null) {
            builder.getMappingsByField().put(secondaryField, mapping);
        }
    }
}

