/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.internal.parsing.IdentificationVariableDeclNode;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.NodeFactory;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class RangeDeclNode
extends IdentificationVariableDeclNode {
    private String abstractSchemaName;

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public void setAbstractSchemaName(String name) {
        this.abstractSchemaName = name;
    }

    public Node qualifyAttributeAccess(ParseTreeContext context) {
        String name;
        TypeHelper typeHelper = context.getTypeHelper();
        if (typeHelper.resolveSchema(name = this.abstractSchemaName) == null) {
            context.unregisterVariable(this.getCanonicalVariableName());
            NodeFactory factory = context.getNodeFactory();
            Node path = (Node)factory.newQualifiedAttribute(this.getLine(), this.getColumn(), context.getBaseVariable(), name);
            return (Node)factory.newVariableDecl(this.getLine(), this.getColumn(), path, this.getVariableName());
        }
        return this;
    }

    public void validate(ParseTreeContext context) {
        super.validate(context);
        TypeHelper typeHelper = context.getTypeHelper();
        Object type = typeHelper.resolveSchema(this.abstractSchemaName);
        if (type == null) {
            throw EJBQLException.unknownAbstractSchemaType2(context.getQueryInfo(), this.getLine(), this.getColumn(), this.abstractSchemaName);
        }
        this.setType(type);
    }
}

