/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.jdbc.base;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.toplink.essentials.internal.ejb.cmp3.transaction.base.TransactionManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceImpl
implements DataSource {
    String dsName;
    String url;
    String userName;
    String password;
    TransactionManagerImpl tm;

    private void debug(String s) {
        System.out.println(s);
    }

    public DataSourceImpl(String dsName, String url, String userName, String password) {
        this.dsName = dsName;
        this.url = url;
        this.userName = userName;
        this.password = password;
    }

    public String getName() {
        return this.dsName;
    }

    public void setTransactionManager(TransactionManagerImpl tm) {
        this.tm = tm;
    }

    public Connection internalGetConnection(String userName, String password) throws SQLException {
        return DriverManager.getConnection(this.url, userName, password);
    }

    public Connection internalGetConnection() throws SQLException {
        return this.internalGetConnection(this.userName, this.password);
    }

    public boolean isTransactional() {
        return this.tm != null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userName, this.password);
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        if (this.isTransactional() && this.tm.isTransactionActive()) {
            return this.tm.getConnection(this, userName, password);
        }
        this.debug("Ds - Allocating new non-tx connection");
        return this.internalGetConnection(userName, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

