/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.databaseaccess;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.databaseaccess.OutputParameterForCallableStatement;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class InOutputParameterForCallableStatement
extends OutputParameterForCallableStatement {
    protected Object inParameter;

    public InOutputParameterForCallableStatement(Object inParameter, OutputParameterForCallableStatement outParameter) {
        super(outParameter);
        this.inParameter = inParameter == null ? this.getOutputField() : inParameter;
    }

    public InOutputParameterForCallableStatement(Object inParameter, DatabaseField outField, DatabasePlatform platform) {
        if (outField.getType() == null && inParameter != null) {
            DatabaseField typeField = (DatabaseField)outField.clone();
            if (inParameter instanceof DatabaseField) {
                typeField.setType(((DatabaseField)inParameter).getType());
            } else {
                typeField.setType(inParameter.getClass());
            }
            outField = typeField;
        }
        this.obj = outField;
        this.prepare(platform);
        this.inParameter = inParameter == null ? this.getOutputField() : inParameter;
    }

    public void set(DatabasePlatform platform, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        platform.setParameterValueInDatabaseCall(this.inParameter, statement, index, session);
        super.set(platform, statement, index, session);
    }

    public String toString() {
        String strIn = this.inParameter instanceof DatabaseField ? "null" : this.inParameter.toString();
        return strIn + " " + super.toString();
    }
}

