/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings.foundation;

import java.math.BigDecimal;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ConversionException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.DirectToFieldChangeRecord;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.converters.Converter;
import oracle.toplink.essentials.mappings.converters.ObjectTypeConverter;
import oracle.toplink.essentials.mappings.converters.TypeConversionConverter;
import oracle.toplink.essentials.queryframework.ObjectBuildingQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.sessions.ObjectCopyingPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDirectMapping
extends DatabaseMapping {
    protected DatabaseField field;
    protected transient Class attributeClassification;
    protected transient String attributeClassificationName;
    protected transient Class attributeObjectClassification;
    protected Converter converter;
    protected transient Object nullValue;
    protected Boolean isMutable;

    public AbstractDirectMapping() {
        this.setWeight(WEIGHT_1);
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public boolean isMutable() {
        if (this.isMutable == null) {
            return false;
        }
        return this.isMutable;
    }

    public void setIsMutable(boolean isMutable) {
        this.isMutable = isMutable ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        this.buildClone(clone, backup, unitOfWork);
    }

    @Override
    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork) {
        this.buildCloneValue(original, clone, unitOfWork);
    }

    public void buildCloneValue(Object original, Object clone, AbstractSession session) {
        if (this.isCloningRequired()) {
            Object attributeValue = this.getAttributeValueFromObject(original);
            if (this.isMutable()) {
                attributeValue = this.getAttributeValue(this.getFieldValue(attributeValue, session), session);
            }
            this.setAttributeValueInObject(clone, attributeValue);
        }
    }

    @Override
    public void buildCopy(Object copy, Object original, ObjectCopyingPolicy policy) {
        this.buildCloneValue(original, copy, policy.getSession());
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
    }

    @Override
    public Object clone() {
        AbstractDirectMapping clone = (AbstractDirectMapping)super.clone();
        clone.setField((DatabaseField)this.getField().clone());
        return clone;
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        Vector<DatabaseField> databaseField = new Vector<DatabaseField>(1);
        databaseField.addElement(this.getField());
        return databaseField;
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        if (owner.isNew() || !this.compareObjects(backUp, clone, session)) {
            return this.buildChangeRecord(clone, owner, session);
        }
        return null;
    }

    @Override
    public ChangeRecord buildChangeRecord(Object clone, ObjectChangeSet owner, AbstractSession session) {
        return this.internalBuildChangeRecord(this.getAttributeValueFromObject(clone), owner);
    }

    public ChangeRecord internalBuildChangeRecord(Object newValue, ObjectChangeSet owner) {
        DirectToFieldChangeRecord changeRecord = new DirectToFieldChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.setNewValue(newValue);
        return changeRecord;
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object two;
        Object one = this.getAttributeValueFromObject(firstObject);
        if (one == (two = this.getAttributeValueFromObject(secondObject))) {
            return true;
        }
        if ((one = this.getFieldValue(one, session)) == (two = this.getFieldValue(two, session))) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.getClass() == ClassConstants.APBYTE && two.getClass() == ClassConstants.APBYTE) {
            return Helper.compareByteArrays((byte[])one, (byte[])two);
        }
        if (one.getClass() == ClassConstants.APCHAR && two.getClass() == ClassConstants.APCHAR) {
            return Helper.compareCharArrays((char[])one, (char[])two);
        }
        if (one.getClass().isArray() && two.getClass().isArray()) {
            return Helper.compareArrays((Object[])one, (Object[])two);
        }
        if (one instanceof BigDecimal && two instanceof BigDecimal) {
            return Helper.compareBigDecimals((BigDecimal)one, (BigDecimal)two);
        }
        return one.equals(two);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.converter != null) {
            if (this.converter instanceof TypeConversionConverter) {
                ((TypeConversionConverter)this.converter).convertClassNamesToClasses(classLoader);
            } else if (this.converter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.converter).convertClassNamesToClasses(classLoader);
            }
        }
    }

    @Override
    public Class getAttributeClassification() {
        return this.attributeClassification;
    }

    public String getAttributeClassificationName() {
        return this.attributeClassificationName;
    }

    public Object getAttributeValue(Object fieldValue, AbstractSession session) {
        Object attributeValue = fieldValue;
        if (fieldValue == null && this.getNullValue() != null) {
            return this.nullValue;
        }
        if (this.converter != null) {
            attributeValue = this.converter.convertDataValueToObjectValue(attributeValue, session);
        } else if (attributeValue == null || attributeValue.getClass() != this.attributeObjectClassification) {
            try {
                attributeValue = session.getDatasourcePlatform().convertObject(attributeValue, this.attributeClassification);
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
        }
        if (attributeValue == null) {
            attributeValue = this.nullValue;
        }
        return attributeValue;
    }

    @Override
    public DatabaseField getField() {
        return this.field;
    }

    @Override
    public boolean isAbstractDirectMapping() {
        return true;
    }

    @Override
    public Class getFieldClassification(DatabaseField fieldToClassify) {
        if (fieldToClassify.type != null) {
            return fieldToClassify.type;
        }
        if (this.converter != null) {
            return null;
        }
        return this.attributeClassification;
    }

    public Class getFieldClassification() {
        if (this.getField() == null) {
            return null;
        }
        return this.getField().getType();
    }

    public void setFieldClassification(Class fieldType) {
        this.getField().setType(fieldType);
    }

    public void setFieldType(int jdbcType) {
        this.getField().setSqlType(jdbcType);
    }

    public String getFieldName() {
        return this.getField().getQualifiedName();
    }

    public Object getFieldValue(Object attributeValue, AbstractSession session) {
        Object fieldValue = attributeValue;
        if (this.nullValue != null && this.nullValue.equals(fieldValue)) {
            return null;
        }
        if (this.converter != null) {
            fieldValue = this.converter.convertObjectValueToDataValue(fieldValue, session);
        }
        Class fieldClassification = this.getFieldClassification(this.getField());
        if (fieldValue == null || fieldClassification != fieldValue.getClass()) {
            try {
                fieldValue = session.getPlatform(this.getDescriptor().getJavaClass()).convertObject(fieldValue, fieldClassification);
            }
            catch (ConversionException exception) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), exception);
            }
        }
        return fieldValue;
    }

    public Object getNullValue() {
        return this.nullValue;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        super.preInitialize(session);
        this.attributeClassification = this.getAttributeAccessor().getAttributeClass();
        this.attributeObjectClassification = Helper.getObjectClass(this.attributeClassification);
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.isMutable == null) {
            if (this.getConverter() != null) {
                this.setIsMutable(this.getConverter().isMutable());
            } else {
                this.setIsMutable(false);
            }
        }
        if (this.getField() == null) {
            session.getIntegrityChecker().handleError(DescriptorException.fieldNameNotSetInMapping(this));
        }
        this.getDescriptor().buildField(this.getField());
        this.setFields(this.collectFields());
        if (this.getConverter() != null) {
            this.getConverter().initialize(this, session);
        }
    }

    @Override
    public boolean isDirectToFieldMapping() {
        return true;
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        if (iterator.shouldIterateOnPrimitives()) {
            iterator.iteratePrimitiveForMapping(this.getAttributeValueFromObject(iterator.getVisitedParent()), this);
        }
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        this.setAttributeValueInObject(target, ((DirectToFieldChangeRecord)changeRecord).getNewValue());
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        Object attributeValue = this.getAttributeValueFromObject(source);
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && !this.compareObjects(target, source, mergeManager.getSession())) {
            Object targetAttribute = this.getAttributeValueFromObject(target);
            this.setAttributeValueInObject(target, attributeValue);
            this.getDescriptor().getObjectChangePolicy().raiseInternalPropertyChangeEvent(target, this.getAttributeName(), targetAttribute, attributeValue);
        } else {
            this.setAttributeValueInObject(target, attributeValue);
        }
    }

    public void setAttributeClassification(Class attributeClassification) {
        this.attributeClassification = attributeClassification;
    }

    public void setAttributeClassificationName(String attributeClassificationName) {
        this.attributeClassificationName = attributeClassificationName;
    }

    public void setField(DatabaseField theField) {
        this.field = theField;
    }

    public void setNullValue(Object nullValue) {
        this.nullValue = nullValue;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.getAttributeName() + "-->" + this.getField() + "]";
    }

    @Override
    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        DirectToFieldChangeRecord changeRecord = (DirectToFieldChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            objectChangeSet.addChange(this.internalBuildChangeRecord(newValue, objectChangeSet));
        } else {
            changeRecord.setNewValue(newValue);
        }
    }

    @Override
    public boolean isChangeTrackingSupported() {
        return !this.isMutable();
    }

    @Override
    public boolean isCloningRequired() {
        return this.isMutable() || this.getDescriptor().getCopyPolicy().buildsNewInstance();
    }

    @Override
    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
        if (this.getFieldName() == null || this.getFieldName().length() == 0) {
            session.getIntegrityChecker().handleError(DescriptorException.noFieldNameForMapping(this));
        }
    }

    @Override
    public Object valueFromObject(Object object, DatabaseField field, AbstractSession session) throws DescriptorException {
        return this.getFieldValue(this.getAttributeValueFromObject(object), session);
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Object attributeValue = this.valueFromRow(databaseRow, joinManager, sourceQuery, executionSession);
        this.setAttributeValueInObject(clone, attributeValue);
    }

    @Override
    public void buildShallowOriginalFromRow(AbstractRecord databaseRow, Object original, ObjectBuildingQuery query, AbstractSession executionSession) {
        this.readFromRowIntoObject(databaseRow, null, original, query, executionSession);
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) {
        Object fieldValue = row.get(this.field);
        Object attributeValue = this.getAttributeValue(fieldValue, executionSession);
        return attributeValue;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        Object fieldValue = this.getFieldValue(attributeValue, session);
        this.writeValueIntoRow(row, this.getField(), fieldValue);
    }

    protected abstract void writeValueIntoRow(AbstractRecord var1, DatabaseField var2, Object var3);

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.isPrimaryKeyMapping() && !changeRecord.getOwner().isNew()) {
            throw ValidationException.primaryKeyUpdateDisallowed(changeRecord.getOwner().getClassName(), changeRecord.getAttribute());
        }
        Object attributeValue = ((DirectToFieldChangeRecord)changeRecord).getNewValue();
        Object fieldValue = this.getFieldValue(attributeValue, session);
        row.add(this.getField(), fieldValue);
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery query, AbstractRecord aDatabaseRow) {
        if (query.getSession().isUnitOfWork() && this.compareObjects(query.getBackupClone(), query.getObject(), query.getSession())) {
            return;
        }
        super.writeFromObjectIntoRowForUpdate(query, aDatabaseRow);
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.add(this.getField(), null);
    }
}

