/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.indirection.IndirectSet;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.descriptors.InstanceVariableAttributeAccessor;
import oracle.toplink.essentials.internal.descriptors.MethodAttributeAccessor;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.indirection.TransparentIndirectionPolicy;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.queryframework.SortedCollectionContainerPolicy;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.CollectionChangeRecord;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.ContainerMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DataModifyQuery;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.InsertObjectQuery;
import oracle.toplink.essentials.queryframework.ModifyQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadAllQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.sessions.ObjectCopyingPolicy;

public abstract class CollectionMapping
extends ForeignReferenceMapping
implements ContainerMapping {
    protected transient ModifyQuery deleteAllQuery;
    protected transient boolean hasCustomDeleteAllQuery;
    protected ContainerPolicy containerPolicy;
    protected transient boolean hasOrderBy;

    public CollectionMapping() {
        this.selectionQuery = new ReadAllQuery();
        this.hasCustomDeleteAllQuery = false;
        this.containerPolicy = ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class);
        this.hasOrderBy = false;
    }

    public void addAscendingOrdering(String queryKeyName) {
        if (queryKeyName == null) {
            return;
        }
        ((ReadAllQuery)this.getSelectionQuery()).addAscendingOrdering(queryKeyName);
    }

    public void addDescendingOrdering(String queryKeyName) {
        if (queryKeyName == null) {
            return;
        }
        ((ReadAllQuery)this.getSelectionQuery()).addDescendingOrdering(queryKeyName);
    }

    public void addOrderBy(String queryKeyName, boolean isDescending) {
        this.hasOrderBy = true;
        if (isDescending) {
            this.addDescendingOrdering(queryKeyName);
        } else {
            this.addAscendingOrdering(queryKeyName);
        }
    }

    public void addAggregateOrderBy(String aggregateName, String queryKeyName, boolean isDescending) {
        this.hasOrderBy = true;
        ReadAllQuery readAllQuery = (ReadAllQuery)this.getSelectionQuery();
        ExpressionBuilder builder = readAllQuery.getExpressionBuilder();
        Expression expression = builder.get(aggregateName).get(queryKeyName).toUpperCase();
        if (isDescending) {
            readAllQuery.addOrdering(expression.descending());
        } else {
            readAllQuery.addOrdering(expression.ascending());
        }
    }

    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        if (attributeValue == null) {
            return this.getContainerPolicy().containerInstance(1);
        }
        return this.getContainerPolicy().cloneFor(attributeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (attributeValue == null) {
            Object container = containerPolicy.containerInstance(1);
            return container;
        }
        Object clonedAttributeValue = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
        Object temporaryCollection = null;
        Object object = attributeValue;
        synchronized (object) {
            temporaryCollection = containerPolicy.cloneFor(attributeValue);
        }
        Object valuesIterator = containerPolicy.iteratorFor(temporaryCollection);
        while (containerPolicy.hasNext(valuesIterator)) {
            Object cloneValue = this.buildElementClone(containerPolicy.next(valuesIterator, unitOfWork), unitOfWork, isExisting);
            containerPolicy.addInto(cloneValue, clonedAttributeValue, unitOfWork);
        }
        return clonedAttributeValue;
    }

    public void buildCopy(Object copy, Object original, ObjectCopyingPolicy policy) {
        Object attributeValue = this.getRealCollectionAttributeValueFromObject(original, policy.getSession());
        Object valuesIterator = this.getContainerPolicy().iteratorFor(attributeValue);
        attributeValue = this.getContainerPolicy().containerInstance(this.getContainerPolicy().sizeFor(attributeValue));
        while (this.getContainerPolicy().hasNext(valuesIterator)) {
            Object originalValue;
            Object copyValue = originalValue = this.getContainerPolicy().next(valuesIterator, policy.getSession());
            if (policy.shouldCascadeAllParts() || policy.shouldCascadePrivateParts() && this.isPrivateOwned()) {
                copyValue = policy.getSession().copyObject(originalValue, policy);
            } else {
                copyValue = policy.getCopies().get(originalValue);
                if (copyValue == null) {
                    copyValue = originalValue;
                }
            }
            this.getContainerPolicy().addInto(copyValue, attributeValue, policy.getSession());
        }
        this.setRealAttributeValueInObject(copy, attributeValue);
    }

    protected Object buildElementClone(Object element, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        if (isExisting) {
            return unitOfWork.registerExistingObject(element);
        }
        return unitOfWork.registerObject(element);
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null || !this.isCascadeRemove()) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object nextObject = cp.next(cloneIter, uow);
            if (nextObject == null || visitedObjects.contains(nextObject)) continue;
            visitedObjects.put(nextObject, nextObject);
            uow.performRemove(nextObject, visitedObjects);
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null || !this.isCascadePersist() || !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object nextObject = cp.next(cloneIter, uow);
            uow.registerNewObjectForPersist(nextObject, visitedObjects);
        }
    }

    private void checkMapClass(Class concreteClass) {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        if (!Helper.classImplementsInterface(concreteClass, ClassConstants.Map_Class)) {
            throw ValidationException.illegalContainerClass(concreteClass);
        }
    }

    public void calculateDeferredChanges(ChangeRecord changeRecord, AbstractSession session) {
        CollectionChangeRecord collectionRecord = (CollectionChangeRecord)changeRecord;
        this.compareCollectionsForChange(collectionRecord.getOriginalCollection(), collectionRecord.getLatestCollection(), collectionRecord, session);
    }

    public void cascadeMerge(Object sourceElement, MergeManager mergeManager) {
        if (this.shouldMergeCascadeParts(mergeManager)) {
            mergeManager.mergeChanges(mergeManager.getObjectToMerge(sourceElement), null);
        }
    }

    public void compareCollectionsForChange(Object oldCollection, Object newCollection, ChangeRecord changeRecord, AbstractSession session) {
        this.getContainerPolicy().compareCollectionsForChange(oldCollection, newCollection, (CollectionChangeRecord)changeRecord, session, this.getReferenceDescriptor());
    }

    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        Object backUpObjectCollection = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (cloneAttribute == null && backUpAttribute == null) {
                return null;
            }
            backUpObjectCollection = this.getRealCollectionAttributeValueFromObject(backUp, session);
        }
        Object cloneObjectCollection = null;
        cloneObjectCollection = cloneAttribute != null ? this.getRealCollectionAttributeValueFromObject(clone, session) : this.getContainerPolicy().containerInstance(1);
        CollectionChangeRecord changeRecord = new CollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        this.compareCollectionsForChange(backUpObjectCollection, cloneObjectCollection, changeRecord, session);
        if (changeRecord.hasChanges()) {
            return changeRecord;
        }
        return null;
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstObjectCollection = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondObjectCollection = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        return super.compareObjects(firstObjectCollection, secondObjectCollection, session);
    }

    protected void compareObjectsAndWrite(Object previousObjects, Object currentObjects, WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        CacheKey key;
        Vector primaryKey;
        Object currentObject;
        ContainerPolicy cp = this.getContainerPolicy();
        if (query.getObjectChangeSet() != null && !this.isAggregateCollectionMapping()) {
            ObjectChangeSet changeSet = query.getObjectChangeSet();
            CollectionChangeRecord record = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
            if (record != null) {
                ObjectChangeSet removedChangeSet = null;
                ObjectChangeSet addedChangeSet = null;
                UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)changeSet.getUOWChangeSet();
                Enumeration removedObjects = record.getRemoveObjectList().elements();
                while (removedObjects.hasMoreElements()) {
                    removedChangeSet = (ObjectChangeSet)removedObjects.nextElement();
                    this.objectRemovedDuringUpdate(query, removedChangeSet.getUnitOfWorkClone());
                }
                Enumeration addedObjects = record.getAddObjectList().elements();
                while (addedObjects.hasMoreElements()) {
                    addedChangeSet = (ObjectChangeSet)addedObjects.nextElement();
                    this.objectAddedDuringUpdate(query, addedChangeSet.getUnitOfWorkClone(), addedChangeSet);
                }
            }
            return;
        }
        Hashtable<CacheKey, Object> previousObjectsByKey = new Hashtable<CacheKey, Object>(cp.sizeFor(previousObjects) + 2);
        Hashtable<CacheKey, Object> currentObjectsByKey = new Hashtable<CacheKey, Object>(cp.sizeFor(currentObjects) + 2);
        IdentityHashtable cacheKeysOfCurrentObjects = new IdentityHashtable(cp.sizeFor(currentObjects) + 1);
        Object currentObjectsIter = cp.iteratorFor(currentObjects);
        while (cp.hasNext(currentObjectsIter)) {
            currentObject = cp.next(currentObjectsIter, query.getSession());
            try {
                primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(currentObject, query.getSession());
                key = new CacheKey(primaryKey);
                currentObjectsByKey.put(key, currentObject);
                cacheKeysOfCurrentObjects.put(currentObject, key);
            }
            catch (NullPointerException e) {
                if (currentObject == null) continue;
                throw e;
            }
        }
        Object previousObjectsIter = cp.iteratorFor(previousObjects);
        while (cp.hasNext(previousObjectsIter)) {
            Object previousObject = cp.next(previousObjectsIter, query.getSession());
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(previousObject, query.getSession());
            key = new CacheKey(primaryKey);
            previousObjectsByKey.put(key, previousObject);
            if (currentObjectsByKey.containsKey(key)) continue;
            this.objectRemovedDuringUpdate(query, previousObject);
        }
        currentObjectsIter = cp.iteratorFor(currentObjects);
        while (cp.hasNext(currentObjectsIter)) {
            currentObject = cp.next(currentObjectsIter, query.getSession());
            try {
                CacheKey cacheKey = (CacheKey)cacheKeysOfCurrentObjects.get(currentObject);
                if (!previousObjectsByKey.containsKey(cacheKey)) {
                    this.objectAddedDuringUpdate(query, currentObject, null);
                    continue;
                }
                this.objectUnchangedDuringUpdate(query, currentObject, previousObjectsByKey, cacheKey);
            }
            catch (NullPointerException e) {
                if (currentObject == null) continue;
                throw e;
            }
        }
    }

    protected boolean compareObjectsWithoutPrivateOwned(Object firstCollection, Object secondCollection, AbstractSession session) {
        Vector primaryKey;
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.sizeFor(firstCollection) != cp.sizeFor(secondCollection)) {
            return false;
        }
        Object firstIter = cp.iteratorFor(firstCollection);
        Object secondIter = cp.iteratorFor(secondCollection);
        Vector<CacheKey> keyValue = new Vector<CacheKey>();
        while (cp.hasNext(secondIter)) {
            Object secondObject = cp.next(secondIter, session);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(secondObject, session);
            keyValue.addElement(new CacheKey(primaryKey));
        }
        while (cp.hasNext(firstIter)) {
            Object firstObject = cp.next(firstIter, session);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(firstObject, session);
            if (keyValue.contains(new CacheKey(primaryKey))) continue;
            return false;
        }
        return true;
    }

    protected boolean compareObjectsWithPrivateOwned(Object firstCollection, Object secondCollection, AbstractSession session) {
        Vector primaryKey;
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.sizeFor(firstCollection) != cp.sizeFor(secondCollection)) {
            return false;
        }
        Object firstIter = cp.iteratorFor(firstCollection);
        Object secondIter = cp.iteratorFor(secondCollection);
        Hashtable<CacheKey, Object> keyValueToObject = new Hashtable<CacheKey, Object>(cp.sizeFor(firstCollection) + 2);
        while (cp.hasNext(secondIter)) {
            Object secondObject = cp.next(secondIter, session);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(secondObject, session);
            keyValueToObject.put(new CacheKey(primaryKey), secondObject);
        }
        while (cp.hasNext(firstIter)) {
            Object firstObject = cp.next(firstIter, session);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(firstObject, session);
            CacheKey cacheKey = new CacheKey(primaryKey);
            if (keyValueToObject.containsKey(cacheKey)) {
                Object object = keyValueToObject.get(cacheKey);
                if (session.compareObjects(firstObject, object)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        this.containerPolicy.convertClassNamesToClasses(classLoader);
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    protected ModifyQuery getDeleteAllQuery() {
        if (this.deleteAllQuery == null) {
            this.deleteAllQuery = new DataModifyQuery();
        }
        return this.deleteAllQuery;
    }

    public Object getRealAttributeValueFromObject(Object object, AbstractSession session) throws DescriptorException {
        Object value = super.getRealAttributeValueFromObject(object, session);
        if (value != null && !this.getContainerPolicy().isValidContainer(value)) {
            throw DescriptorException.attributeTypeNotValid(this);
        }
        return value;
    }

    public Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession session) throws DescriptorException {
        Object value = this.getRealAttributeValueFromObject(object, session);
        if (value == null) {
            value = this.getContainerPolicy().containerInstance(1);
        }
        return value;
    }

    protected boolean hasCustomDeleteAllQuery() {
        return this.hasCustomDeleteAllQuery;
    }

    public boolean hasOrderBy() {
        return this.hasOrderBy;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.setFields(this.collectFields());
        this.getContainerPolicy().prepare(this.getSelectionQuery(), session);
        if (!this.usesIndirection() && !this.getAttributeAccessor().getAttributeClass().isAssignableFrom(this.getContainerPolicy().getContainerClass())) {
            throw DescriptorException.incorrectCollectionPolicy(this, this.getAttributeAccessor().getAttributeClass(), this.getContainerPolicy().getContainerClass());
        }
    }

    public boolean isCollectionMapping() {
        return true;
    }

    public void iterateOnElement(DescriptorIterator iterator, Object element) {
        iterator.iterateReferenceObjectForMapping(element, this);
    }

    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        if (realAttributeValue == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(realAttributeValue);
        while (cp.hasNext(iter)) {
            this.iterateOnElement(iterator, cp.next(iter, iterator.getSession()));
        }
    }

    public void mergeChangesIntoObject(Object target, ChangeRecord chgRecord, Object source, MergeManager mergeManager) {
        Object valueOfTarget = null;
        Object valueOfSource = null;
        AbstractSession parentSession = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        CollectionChangeRecord changeRecord = (CollectionChangeRecord)chgRecord;
        UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet();
        if (this.isAttributeValueInstantiated(target)) {
            valueOfTarget = changeRecord.getOwner().isNew() ? containerPolicy.containerInstance(changeRecord.getAddObjectList().size()) : this.getRealCollectionAttributeValueFromObject(target, mergeManager.getSession());
            parentSession = mergeManager.getSession().isUnitOfWork() && !mergeManager.shouldMergeWorkingCopyIntoBackup() ? ((UnitOfWorkImpl)mergeManager.getSession()).getParent() : mergeManager.getSession();
            containerPolicy.mergeChanges(changeRecord, valueOfTarget, this.shouldMergeCascadeParts(mergeManager), mergeManager, parentSession);
        } else {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
            Object iterator = containerPolicy.iteratorFor(valueOfSource);
            valueOfTarget = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
            while (containerPolicy.hasNext(iterator)) {
                Object objectToMerge = containerPolicy.next(iterator, mergeManager.getSession());
                ObjectChangeSet changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(objectToMerge);
                if (this.shouldMergeCascadeParts(mergeManager) && valueOfSource != null) {
                    mergeManager.mergeChanges(objectToMerge, changeSet);
                }
                containerPolicy.addInto(mergeManager.getTargetVersionOfSourceObject(objectToMerge), valueOfTarget, mergeManager.getSession());
            }
        }
        if (valueOfTarget == null) {
            valueOfTarget = containerPolicy.containerInstance();
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(target) : !this.isAttributeValueInstantiated(source)) {
            return;
        }
        Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        AbstractSession mergeSession = mergeManager.getSession();
        Object valueOfTarget = this.getRealCollectionAttributeValueFromObject(target, mergeSession);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        boolean fireChangeEvents = false;
        if (!mergeManager.shouldMergeOriginalIntoWorkingCopy()) {
            Object newContainer;
            valueOfTarget = newContainer = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
        } else {
            this.setRealAttributeValueInObject(target, containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource)));
            containerPolicy.clear(valueOfTarget);
        }
        Object object = valueOfSource;
        synchronized (object) {
            Object sourceIterator = containerPolicy.iteratorFor(valueOfSource);
            while (containerPolicy.hasNext(sourceIterator)) {
                Object object2 = containerPolicy.next(sourceIterator, mergeManager.getSession());
                if (object2 == null) continue;
                if (this.shouldMergeCascadeParts(mergeManager)) {
                    if (mergeManager.getSession().isUnitOfWork() && ((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet() != null) {
                        mergeManager.mergeChanges(mergeManager.getObjectToMerge(object2), (ObjectChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object2));
                    } else {
                        mergeManager.mergeChanges(mergeManager.getObjectToMerge(object2), null);
                    }
                }
                object2 = this.getReferenceDescriptor().getObjectBuilder().wrapObject(mergeManager.getTargetVersionOfSourceObject(object2), mergeManager.getSession());
                Object object3 = valueOfTarget;
                synchronized (object3) {
                    containerPolicy.addInto(object2, valueOfTarget, mergeManager.getSession());
                }
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery query, Object objectAdded, ObjectChangeSet changeSet) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        if (this.isPrivateOwned()) {
            InsertObjectQuery insertQuery = new InsertObjectQuery();
            insertQuery.setObject(objectAdded);
            insertQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(insertQuery);
        } else {
            UnitOfWorkChangeSet uowChangeSet = null;
            if (changeSet == null && query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(query.getObject());
            }
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setObject(objectAdded);
            writeQuery.setObjectChangeSet(changeSet);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery query, Object objectDeleted) throws DatabaseException, OptimisticLockException {
        if (this.isPrivateOwned()) {
            if (query.shouldCascadeOnlyDependentParts()) {
                if (query.getSession().isUnitOfWork()) {
                    if (!((UnitOfWorkImpl)query.getSession()).getDeletedObjects().containsKey(objectDeleted)) {
                        query.getSession().getCommitManager().addObjectToDelete(objectDeleted);
                    }
                } else {
                    query.getSession().getCommitManager().addObjectToDelete(objectDeleted);
                }
            } else {
                query.getSession().deleteObject(objectDeleted);
            }
        }
    }

    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery query, Object object) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        WriteObjectQuery writeQuery = new WriteObjectQuery();
        writeQuery.setObject(object);
        writeQuery.setCascadePolicy(query.getCascadePolicy());
        query.getSession().executeQuery(writeQuery);
    }

    protected void prepareTranslationRow(AbstractRecord translationRow, Object object, AbstractSession session) {
    }

    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery query, Object object, Hashtable backupclones, CacheKey keys) throws DatabaseException, OptimisticLockException {
        this.objectUnchangedDuringUpdate(query, object);
    }

    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery modifyQuery) throws DatabaseException {
        if (modifyQuery.getSession().isUnitOfWork()) {
            return this.getRealCollectionAttributeValueFromObject(modifyQuery.getBackupClone(), modifyQuery.getSession());
        }
        this.prepareTranslationRow(modifyQuery.getTranslationRow(), modifyQuery.getObject(), modifyQuery.getSession());
        return modifyQuery.getSession().executeQuery((DatabaseQuery)this.getSelectionQuery(), modifyQuery.getTranslationRow());
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        ((ReadAllQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setCustomDeleteAllQuery(ModifyQuery query) {
        this.setDeleteAllQuery(query);
        this.setHasCustomDeleteAllQuery(true);
    }

    protected void setDeleteAllQuery(ModifyQuery query) {
        this.deleteAllQuery = query;
    }

    public void setDeleteAllSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteAllQuery(query);
    }

    public void setDeleteAllCall(Call call) {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        this.setCustomDeleteAllQuery(query);
    }

    protected void setHasCustomDeleteAllQuery(boolean bool) {
        this.hasCustomDeleteAllQuery = bool;
    }

    public void setSessionName(String name) {
        this.getDeleteAllQuery().setSessionName(name);
        this.getSelectionQuery().setSessionName(name);
    }

    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            collectionChangeRecord.getAddObjectList().put(changeSetToAdd, changeSetToAdd);
            collectionChangeRecord.getOrderedAddObjects().add(changeSetToAdd);
            changeSet.addChange(collectionChangeRecord);
        } else {
            this.getContainerPolicy().recordAddToCollectionInChangeRecord((ObjectChangeSet)changeSetToAdd, collectionChangeRecord);
        }
        if (referenceKey != null) {
            ((ObjectChangeSet)changeSetToAdd).setNewKey(referenceKey);
        }
    }

    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            collectionChangeRecord.getRemoveObjectList().put(changeSetToRemove, changeSetToRemove);
            changeSet.addChange(collectionChangeRecord);
        } else {
            this.getContainerPolicy().recordRemoveFromCollectionInChangeRecord((ObjectChangeSet)changeSetToRemove, collectionChangeRecord);
        }
        if (referenceKey != null) {
            ((ObjectChangeSet)changeSetToRemove).setOldKey(referenceKey);
        }
    }

    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        if (collectionChangeRecord.getOriginalCollection() == null) {
            collectionChangeRecord.setOriginalCollection(oldValue);
        }
        collectionChangeRecord.setLatestCollection(newValue);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
    }

    public void useCollectionClass(Class concreteClass) {
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteClass, this.hasOrderBy());
        this.setContainerPolicy(policy);
    }

    public void useSortedSetClass(Class concreteClass, Comparator comparator) {
        try {
            SortedCollectionContainerPolicy policy = (SortedCollectionContainerPolicy)ContainerPolicy.buildPolicyFor(concreteClass);
            policy.setComparator(comparator);
            this.setContainerPolicy(policy);
        }
        catch (ClassCastException e) {
            this.useCollectionClass(concreteClass);
        }
    }

    public void useMapClass(Class concreteClass, String keyName) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteClass);
        policy.setKeyName(keyName, this.getReferenceClassName());
        this.setContainerPolicy(policy);
    }

    public void useMapClass(Class concreteClass) {
        this.useMapClass(concreteClass, null);
    }

    public void useTransparentCollection() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(ClassConstants.IndirectList_Class);
    }

    public void useTransparentSet() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(IndirectSet.class);
    }

    public void useTransparentList() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(ClassConstants.IndirectList_Class);
    }

    public void useTransparentMap(String methodName) {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useMapClass(ClassConstants.IndirectMap_Class, methodName);
    }

    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
        super.validateBeforeInitialization(session);
        this.getIndirectionPolicy().validateContainerPolicy(session.getIntegrityChecker());
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class attributeType = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.getIndirectionPolicy().validateDeclaredAttributeTypeForCollection(attributeType, session.getIntegrityChecker());
        } else if (this.getAttributeAccessor() instanceof MethodAttributeAccessor) {
            Class returnType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.getIndirectionPolicy().validateGetMethodReturnTypeForCollection(returnType, session.getIntegrityChecker());
            Class parameterType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.getIndirectionPolicy().validateSetMethodParameterTypeForCollection(parameterType, session.getIntegrityChecker());
        }
    }

    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        if (this.isPrivateOwned()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(object, session);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object iter = containerPolicy.iteratorFor(objects);
            while (containerPolicy.hasNext(iter)) {
                if (session.verifyDelete(containerPolicy.next(iter, session))) continue;
                return false;
            }
        }
        AbstractRecord row = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, session);
        this.prepareTranslationRow(row, object, session);
        Object value = session.executeQuery((DatabaseQuery)this.getSelectionQuery(), row);
        return this.getContainerPolicy().isEmpty(value);
    }

    public void addToCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        if (newValue != null) {
            ClassDescriptor descriptor = !this.getReferenceDescriptor().hasInheritance() ? this.getReferenceDescriptor() : uow.getDescriptor(newValue);
            newValue = descriptor.getObjectBuilder().unwrapObject(newValue, uow);
            ObjectChangeSet newSet = descriptor.getObjectBuilder().createObjectChangeSet(newValue, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), uow);
            this.simpleAddToCollectionChangeRecord(newKey, newSet, objectChangeSet, uow);
        }
    }

    public boolean isChangeTrackingSupported() {
        return true;
    }

    public void removeFromCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        if (newValue != null) {
            ClassDescriptor descriptor = !this.getReferenceDescriptor().hasInheritance() ? this.getReferenceDescriptor() : uow.getDescriptor(newValue);
            newValue = descriptor.getObjectBuilder().unwrapObject(newValue, uow);
            ObjectChangeSet newSet = descriptor.getObjectBuilder().createObjectChangeSet(newValue, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), uow);
            this.simpleRemoveFromCollectionChangeRecord(newKey, newSet, objectChangeSet, uow);
        }
    }

    public ChangeRecord buildChangeRecord(Object clone, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        IdentityHashMap<Object, Object> cloneKeyValues = new IdentityHashMap<Object, Object>();
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = cloneAttribute != null ? this.getRealCollectionAttributeValueFromObject(clone, session) : cp.containerInstance(1);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object firstObject = cp.next(cloneIter, session);
            if (firstObject == null) continue;
            cloneKeyValues.put(firstObject, firstObject);
        }
        CollectionChangeRecord changeRecord = new CollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.addAdditionChange(cloneKeyValues, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
        if (changeRecord.hasChanges()) {
            return changeRecord;
        }
        return null;
    }

    protected boolean shouldUseValueFromRowWithJoin(JoinedAttributeManager joinManager) {
        return joinManager.getDataResults_() != null && super.shouldUseValueFromRowWithJoin(joinManager);
    }

    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, AbstractSession executionSession) throws DatabaseException {
        List rows = joinManager.getDataResults_();
        Object value = this.getContainerPolicy().containerInstance();
        ObjectLevelReadQuery nestedQuery = null;
        nestedQuery = joinManager.getJoinedMappingQueries_() != null ? (ObjectLevelReadQuery)joinManager.getJoinedMappingQueries_().get(this) : this.prepareNestedJoins(joinManager, executionSession);
        nestedQuery.setSession(executionSession);
        nestedQuery.setQueryId(joinManager.getBaseQuery().getQueryId());
        Vector sourceKey = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(row, executionSession);
        CacheKey sourceCacheKey = new CacheKey(sourceKey);
        HashSet<CacheKey> targetCacheKeys = new HashSet<CacheKey>();
        for (int index = 0; index < rows.size(); ++index) {
            AbstractRecord sourceRow = (AbstractRecord)rows.get(index);
            AbstractRecord targetRow = sourceRow;
            if (targetRow == null) continue;
            targetRow = this.trimRowForJoin(targetRow, joinManager, executionSession);
            AbstractRecord pkRow = this.trimRowForJoin(sourceRow, new Integer(joinManager.getParentResultIndex()), executionSession);
            nestedQuery.setTranslationRow(targetRow);
            Vector rowSourceKey = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(pkRow, executionSession);
            if (rowSourceKey != null) {
                CacheKey rowSourceCacheKey = new CacheKey(rowSourceKey);
                if (!sourceCacheKey.equals(rowSourceCacheKey)) continue;
                Vector targetKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(targetRow, executionSession);
                if (targetKey == null) {
                    return this.getIndirectionPolicy().valueFromRow(value);
                }
                CacheKey targetCacheKey = new CacheKey(targetKey);
                if (targetCacheKeys.contains(targetCacheKey)) continue;
                targetCacheKeys.add(targetCacheKey);
                Object targetObject = this.getReferenceDescriptor().getObjectBuilder().buildObject(nestedQuery, targetRow, nestedQuery.getJoinedAttributeManager());
                nestedQuery.setTranslationRow(null);
                this.getContainerPolicy().addInto(targetObject, value, executionSession);
                continue;
            }
            rows.set(index, null);
        }
        return this.getIndirectionPolicy().valueFromRow(value);
    }
}

