/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.weaving;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.spi.ClassTransformer;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedGetDeclaredField;
import oracle.toplink.essentials.internal.security.PrivilegedGetDeclaredMethod;
import oracle.toplink.essentials.internal.security.PrivilegedGetField;
import oracle.toplink.essentials.internal.security.PrivilegedGetMethod;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.weaving.AttributeDetails;
import oracle.toplink.essentials.internal.weaving.ClassDetails;
import oracle.toplink.essentials.internal.weaving.TopLinkWeaver;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.sessions.Project;
import oracle.toplink.essentials.sessions.Session;

public class TransformerFactory {
    public static final String WEAVER_NULL_PROJECT = "weaver_null_project";
    public static final String WEAVER_DISABLE_BY_SYSPROP = "weaver_disable_by_system_property";
    public static final String WEAVER_ADDING_EMBEDDABLE = "weaver_adding_embeddable_class";
    public static final String WEAVER_FOUND_FIELD_LOCK = "weaver_found_field_lock";
    public static final String WEAVER_CLASS_NOT_IN_PROJECT = "weaver_class_not_in_project";
    public static final String WEAVER_PROCESSING_CLASS = "weaver_processing_class";
    protected Session session;
    protected Collection entityClasses;
    protected List embeddableClasses;
    protected Map classDetailsMap;
    protected ClassLoader classLoader;

    public static ClassTransformer createTransformerAndModifyProject(Session session, Collection entityClasses, ClassLoader classLoader) {
        if (session == null) {
            throw new IllegalArgumentException("Weaver session cannot be null");
        }
        if (session.getProject() == null) {
            ((AbstractSession)session).log(7, "weaver", WEAVER_NULL_PROJECT, null);
            throw new IllegalArgumentException("Weaver session's project cannot be null");
        }
        TransformerFactory tf = new TransformerFactory(session, entityClasses, classLoader);
        tf.buildClassDetailsAndModifyProject();
        return tf.buildTopLinkWeaver();
    }

    public TransformerFactory(Session session, Collection entityClasses, ClassLoader classLoader) {
        this.session = session;
        this.entityClasses = entityClasses;
        this.classLoader = classLoader;
        this.embeddableClasses = new ArrayList();
        this.classDetailsMap = new HashMap();
    }

    public void addClassDetailsForMappedSuperClasses(Class clz, ClassDescriptor initialDescriptor, ClassDetails classDetails, Map classDetailsMap, List unMappedAttributes) {
        if (initialDescriptor.getInheritancePolicyOrNull() != null && initialDescriptor.getInheritancePolicyOrNull().getParentClass() != null) {
            return;
        }
        if (unMappedAttributes.isEmpty()) {
            return;
        }
        Class superClz = clz.getSuperclass();
        if (superClz == null || superClz == Object.class) {
            return;
        }
        boolean weaveValueHolders = this.canWeaveValueHolders(superClz, unMappedAttributes);
        List stillUnMappedMappings = null;
        ClassDetails superClassDetails = this.createClassDetails(superClz, weaveValueHolders);
        superClassDetails.setIsMappedSuperClass(true);
        if (!classDetailsMap.containsKey(superClassDetails.getClassName())) {
            stillUnMappedMappings = this.storeAttributeMappings(superClz, superClassDetails, unMappedAttributes, weaveValueHolders);
            classDetailsMap.put(superClassDetails.getClassName(), superClassDetails);
        }
        if (stillUnMappedMappings != null && !stillUnMappedMappings.isEmpty()) {
            this.addClassDetailsForMappedSuperClasses(superClz, initialDescriptor, classDetails, classDetailsMap, stillUnMappedMappings);
        }
    }

    public ClassTransformer buildTopLinkWeaver() {
        return new TopLinkWeaver(this.session, this.classDetailsMap);
    }

    public void buildClassDetailsAndModifyProject() {
        if (this.entityClasses != null && this.entityClasses.size() > 0) {
            for (Class clz : this.entityClasses) {
                ClassDescriptor descriptor = this.findDescriptor(this.session.getProject(), clz.getName());
                if (descriptor == null) {
                    this.log(2, WEAVER_CLASS_NOT_IN_PROJECT, new Object[]{clz.getName()});
                    continue;
                }
                this.log(2, WEAVER_PROCESSING_CLASS, new Object[]{clz.getName()});
                boolean weaveValueHolders = this.canWeaveValueHolders(clz, descriptor.getMappings());
                if (!weaveValueHolders) continue;
                ClassDetails classDetails = this.createClassDetails(clz, weaveValueHolders);
                List unMappedAttributes = this.storeAttributeMappings(clz, classDetails, descriptor.getMappings(), weaveValueHolders);
                this.classDetailsMap.put(classDetails.getClassName(), classDetails);
                if (!unMappedAttributes.isEmpty()) {
                    this.addClassDetailsForMappedSuperClasses(clz, descriptor, classDetails, this.classDetailsMap, unMappedAttributes);
                }
                if (classDetails.getLazyOneToOneMappings() == null) continue;
                for (OneToOneMapping mapping : classDetails.getLazyOneToOneMappings()) {
                    mapping.setGetMethodName("_toplink_get" + mapping.getAttributeName() + "_vh");
                    mapping.setSetMethodName("_toplink_set" + mapping.getAttributeName() + "_vh");
                }
            }
            for (ClassDetails classDetails : this.classDetailsMap.values()) {
                ClassDetails superClassDetails = (ClassDetails)this.classDetailsMap.get(classDetails.getSuperClassName());
                if (superClassDetails == null) continue;
                classDetails.setSuperClassDetails(superClassDetails);
            }
            this.embeddableClasses.addAll(this.entityClasses);
            this.entityClasses.clear();
            this.entityClasses.addAll(this.embeddableClasses);
        }
    }

    protected boolean canWeaveValueHolders(Class clz, List mappings) {
        boolean weaveValueHolders = true;
        boolean foundOTOM = false;
        for (DatabaseMapping dm : mappings) {
            String attributeName = dm.getAttributeName();
            if (!dm.isOneToOneMapping()) continue;
            OneToOneMapping otom = (OneToOneMapping)dm;
            Class typeClz = this.getAttributeTypeFromClass(clz, attributeName, dm, true);
            if (!otom.getIndirectionPolicy().usesIndirection() || typeClz == null || typeClz.isAssignableFrom(ValueHolderInterface.class)) continue;
            foundOTOM = true;
            weaveValueHolders = true;
        }
        return weaveValueHolders & foundOTOM;
    }

    private ClassDetails createClassDetails(Class clz, boolean weaveValueHolders) {
        String className = clz.getName().replace('.', '/');
        String superClassName = clz.getSuperclass().getName().replace('.', '/');
        ClassDetails classDetails = new ClassDetails();
        classDetails.setClassName(className);
        classDetails.setSuperClassName(superClassName);
        classDetails.weaveValueHolders(weaveValueHolders);
        return classDetails;
    }

    protected List storeAttributeMappings(Class clz, ClassDetails classDetails, List mappings, boolean weaveValueHolders) {
        Vector<DatabaseMapping> unMappedAttributes = new Vector<DatabaseMapping>();
        HashMap<String, AttributeDetails> attributesMap = new HashMap<String, AttributeDetails>();
        HashMap<String, AttributeDetails> settersMap = new HashMap<String, AttributeDetails>();
        HashMap<String, AttributeDetails> gettersMap = new HashMap<String, AttributeDetails>();
        Vector<OneToOneMapping> lazyMappings = new Vector<OneToOneMapping>();
        for (DatabaseMapping dm : mappings) {
            String attribute = dm.getAttributeName();
            AttributeDetails attributeDetails = new AttributeDetails(attribute);
            Class typeClz = this.getAttributeTypeFromClass(clz, attribute, dm, false);
            if (typeClz == null) {
                attributeDetails.setAttributeOnSuperClass(true);
                if (dm.isOneToOneMapping()) {
                    unMappedAttributes.add(dm);
                }
            }
            if (dm.isCollectionMapping()) {
                attributeDetails.setCollectionMapping(true);
            } else if (dm.isOneToOneMapping()) {
                OneToOneMapping otom = (OneToOneMapping)dm;
                attributeDetails.referenceClass = otom.getReferenceClassName();
                attributeDetails.weaveVH(weaveValueHolders, otom);
                if (otom.getGetMethodName() != null) {
                    gettersMap.put(otom.getGetMethodName(), attributeDetails);
                    if (otom.getSetMethodName() != null) {
                        settersMap.put(otom.getSetMethodName(), attributeDetails);
                    }
                } else {
                    attributeDetails.setIsMappedWithAttributeAccess(true);
                    if (!otom.usesIndirection()) {
                        attributeDetails.weaveVH(false, otom);
                    }
                }
                if (typeClz == null) {
                    typeClz = this.getAttributeTypeFromClass(clz, attribute, dm, true);
                }
                if (weaveValueHolders && otom.getIndirectionPolicy().usesIndirection() && typeClz != null && !typeClz.isAssignableFrom(ValueHolderInterface.class)) {
                    lazyMappings.add(otom);
                }
            }
            attributesMap.put(attribute, attributeDetails);
        }
        classDetails.setAttributesMap(attributesMap);
        classDetails.setGetterMethodToAttributeDetails(gettersMap);
        classDetails.setSetterMethodToAttributeDetails(settersMap);
        classDetails.setLazyOneToOneMappings(lazyMappings);
        return unMappedAttributes;
    }

    protected ClassDescriptor findDescriptor(Project project, String className) {
        for (ClassDescriptor descriptor : project.getOrderedDescriptors()) {
            if (!descriptor.getJavaClassName().equals(className)) continue;
            return descriptor;
        }
        return null;
    }

    private Class getAttributeTypeFromClass(Class clz, String attributeName, DatabaseMapping mapping, boolean checkSuperclass) {
        String getterMethod = mapping.getGetMethodName();
        if (mapping != null && getterMethod != null) {
            try {
                Method method = null;
                if (checkSuperclass) {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            method = (Method)AccessController.doPrivileged(new PrivilegedGetMethod(clz, getterMethod, null, false));
                        }
                        catch (PrivilegedActionException exception) {}
                    } else {
                        method = PrivilegedAccessHelper.getMethod(clz, getterMethod, null, false);
                    }
                } else {
                    method = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            method = (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(clz, getterMethod, null));
                        }
                        catch (PrivilegedActionException exception) {}
                    } else {
                        method = PrivilegedAccessHelper.getDeclaredMethod(clz, getterMethod, null);
                    }
                }
                if (method != null) {
                    return method.getReturnType();
                }
            }
            catch (Exception e) {}
        } else {
            try {
                Class<?> typeClz = null;
                if (checkSuperclass) {
                    Field field = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            field = (Field)AccessController.doPrivileged(new PrivilegedGetField(clz, attributeName, false));
                        }
                        catch (PrivilegedActionException exception) {}
                    } else {
                        field = PrivilegedAccessHelper.getField(clz, attributeName, false);
                    }
                    typeClz = field.getType();
                } else {
                    Field field = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            field = (Field)AccessController.doPrivileged(new PrivilegedGetDeclaredField(clz, attributeName, false));
                        }
                        catch (PrivilegedActionException exception) {}
                    } else {
                        field = PrivilegedAccessHelper.getDeclaredField(clz, attributeName, false);
                    }
                    typeClz = field.getType();
                }
                if (typeClz != null) {
                    return typeClz;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    protected static boolean hasField(Class clz, String fieldName) {
        if ("java.lang.Object".equals(clz.getName())) {
            return false;
        }
        boolean hasField = false;
        try {
            Field f = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    f = (Field)AccessController.doPrivileged(new PrivilegedGetDeclaredField(clz, fieldName, false));
                }
                catch (PrivilegedActionException exception) {}
            } else {
                f = PrivilegedAccessHelper.getDeclaredField(clz, fieldName, false);
            }
            hasField = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasField ? hasField : TransformerFactory.hasField(clz.getSuperclass(), fieldName);
    }

    protected void log(int level, String msg, Object[] params) {
        ((AbstractSession)this.session).log(level, "weaver", msg, params);
    }
}

